/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.syslog4j.util;

import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.graylog2.syslog4j.SyslogCharSetIF;
import org.graylog2.syslog4j.SyslogConstants;
import org.graylog2.syslog4j.SyslogRuntimeException;

public final class SyslogUtility
implements SyslogConstants {
    private static final long serialVersionUID = 915031554586613648L;

    private SyslogUtility() {
    }

    public static final InetAddress getInetAddress(String host) throws SyslogRuntimeException {
        InetAddress address = null;
        try {
            address = InetAddress.getByName(host);
        }
        catch (UnknownHostException uhe) {
            throw new SyslogRuntimeException(uhe);
        }
        return address;
    }

    public static final String getFacilityString(int syslogFacility) {
        switch (syslogFacility) {
            case 0: {
                return "kern";
            }
            case 8: {
                return "user";
            }
            case 16: {
                return "mail";
            }
            case 24: {
                return "daemon";
            }
            case 32: {
                return "auth";
            }
            case 40: {
                return "syslog";
            }
            case 48: {
                return "lpr";
            }
            case 56: {
                return "news";
            }
            case 64: {
                return "uucp";
            }
            case 72: {
                return "cron";
            }
            case 80: {
                return "authpriv";
            }
            case 88: {
                return "ftp";
            }
            case 128: {
                return "local0";
            }
            case 136: {
                return "local1";
            }
            case 144: {
                return "local2";
            }
            case 152: {
                return "local3";
            }
            case 160: {
                return "local4";
            }
            case 168: {
                return "local5";
            }
            case 176: {
                return "local6";
            }
            case 184: {
                return "local7";
            }
        }
        return "UNKNOWN";
    }

    public static final int getFacility(String facilityName) {
        String _facilityName = facilityName;
        if (facilityName == null) {
            return -1;
        }
        _facilityName = facilityName.trim();
        if ("KERN".equalsIgnoreCase(_facilityName)) {
            return 0;
        }
        if ("USER".equalsIgnoreCase(facilityName)) {
            return 8;
        }
        if ("MAIL".equalsIgnoreCase(facilityName)) {
            return 16;
        }
        if ("DAEMON".equalsIgnoreCase(facilityName)) {
            return 24;
        }
        if ("AUTH".equalsIgnoreCase(facilityName)) {
            return 32;
        }
        if ("SYSLOG".equalsIgnoreCase(facilityName)) {
            return 40;
        }
        if ("LPR".equalsIgnoreCase(facilityName)) {
            return 48;
        }
        if ("NEWS".equalsIgnoreCase(facilityName)) {
            return 56;
        }
        if ("UUCP".equalsIgnoreCase(facilityName)) {
            return 64;
        }
        if ("CRON".equalsIgnoreCase(facilityName)) {
            return 72;
        }
        if ("AUTHPRIV".equalsIgnoreCase(facilityName)) {
            return 80;
        }
        if ("FTP".equalsIgnoreCase(facilityName)) {
            return 88;
        }
        if ("LOCAL0".equalsIgnoreCase(facilityName)) {
            return 128;
        }
        if ("LOCAL1".equalsIgnoreCase(facilityName)) {
            return 136;
        }
        if ("LOCAL2".equalsIgnoreCase(facilityName)) {
            return 144;
        }
        if ("LOCAL3".equalsIgnoreCase(facilityName)) {
            return 152;
        }
        if ("LOCAL4".equalsIgnoreCase(facilityName)) {
            return 160;
        }
        if ("LOCAL5".equalsIgnoreCase(facilityName)) {
            return 168;
        }
        if ("LOCAL6".equalsIgnoreCase(facilityName)) {
            return 176;
        }
        if ("LOCAL7".equalsIgnoreCase(facilityName)) {
            return 184;
        }
        return -1;
    }

    public static final int getLevel(String levelName) {
        String _levelName = levelName;
        if (levelName == null) {
            return -1;
        }
        _levelName = levelName.trim();
        if ("DEBUG".equalsIgnoreCase(_levelName)) {
            return 7;
        }
        if ("INFO".equalsIgnoreCase(_levelName)) {
            return 6;
        }
        if ("NOTICE".equalsIgnoreCase(_levelName)) {
            return 5;
        }
        if ("WARN".equalsIgnoreCase(_levelName)) {
            return 4;
        }
        if ("ERROR".equalsIgnoreCase(_levelName)) {
            return 3;
        }
        if ("CRITICAL".equalsIgnoreCase(_levelName)) {
            return 2;
        }
        if ("ALERT".equalsIgnoreCase(_levelName)) {
            return 1;
        }
        if ("EMERGENCY".equalsIgnoreCase(_levelName)) {
            return 0;
        }
        return -1;
    }

    public static final boolean isClassExists(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static final String getLocalName() {
        String localName = "unknown";
        try {
            InetAddress addr = InetAddress.getLocalHost();
            localName = addr.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return localName;
    }

    public static final byte[] getBytes(SyslogCharSetIF syslogCharSet, String data2) {
        byte[] dataBytes = null;
        try {
            dataBytes = data2.getBytes(syslogCharSet.getCharSet());
        }
        catch (UnsupportedEncodingException uee) {
            dataBytes = data2.getBytes();
        }
        return dataBytes;
    }

    public static final String newString(SyslogCharSetIF syslogCharSet, byte[] dataBytes) {
        String data2 = SyslogUtility.newString(syslogCharSet, dataBytes, dataBytes.length);
        return data2;
    }

    public static final String newString(SyslogCharSetIF syslogCharSet, byte[] dataBytes, int dataLength) {
        String data2 = null;
        try {
            data2 = new String(dataBytes, 0, dataLength, syslogCharSet.getCharSet());
        }
        catch (UnsupportedEncodingException uee) {
            data2 = new String(dataBytes);
        }
        return data2;
    }

    public static final String getLevelString(int level) {
        switch (level) {
            case 7: {
                return "DEBUG";
            }
            case 6: {
                return "INFO";
            }
            case 5: {
                return "NOTICE";
            }
            case 4: {
                return "WARN";
            }
            case 3: {
                return "ERROR";
            }
            case 2: {
                return "CRITICAL";
            }
            case 1: {
                return "ALERT";
            }
            case 0: {
                return "EMERGENCY";
            }
        }
        return "UNKNOWN";
    }

    public static void sleep(long duration) {
        try {
            Thread.sleep(duration);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

