/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.syslog4j.server;

import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.graylog2.syslog4j.SyslogConstants;
import org.graylog2.syslog4j.SyslogRuntimeException;
import org.graylog2.syslog4j.server.SyslogServerConfigIF;
import org.graylog2.syslog4j.server.SyslogServerIF;
import org.graylog2.syslog4j.server.SyslogServerMain;
import org.graylog2.syslog4j.server.impl.net.tcp.TCPNetSyslogServerConfig;
import org.graylog2.syslog4j.server.impl.net.udp.UDPNetSyslogServerConfig;
import org.graylog2.syslog4j.util.SyslogUtility;

public class SyslogServer
implements SyslogConstants {
    private static final long serialVersionUID = -2260889360828258602L;
    private static boolean SUPPRESS_RUNTIME_EXCEPTIONS = false;
    protected static final Map instances = new Hashtable();

    private SyslogServer() {
    }

    public static final String getVersion() {
        return "Syslog4j-graylog2 0.9.48 kroepke";
    }

    public static void setSuppressRuntimeExceptions(boolean suppress) {
        SUPPRESS_RUNTIME_EXCEPTIONS = suppress;
    }

    public static boolean getSuppressRuntimeExceptions() {
        return SUPPRESS_RUNTIME_EXCEPTIONS;
    }

    private static void throwRuntimeException(String message) throws SyslogRuntimeException {
        if (SUPPRESS_RUNTIME_EXCEPTIONS) {
            return;
        }
        throw new SyslogRuntimeException(message.toString());
    }

    public static final SyslogServerIF getInstance(String protocol) throws SyslogRuntimeException {
        String syslogProtocol = protocol.toLowerCase();
        if (instances.containsKey(syslogProtocol)) {
            return (SyslogServerIF)instances.get(syslogProtocol);
        }
        SyslogServer.throwRuntimeException("SyslogServer instance \"" + syslogProtocol + "\" not defined; use \"tcp\" or \"udp\" or call SyslogServer.createInstance(protocol,config) first");
        return null;
    }

    public static final SyslogServerIF getThreadedInstance(String protocol) throws SyslogRuntimeException {
        SyslogServerIF server = SyslogServer.getInstance(protocol);
        if (server.getThread() == null) {
            Thread thread = new Thread(server);
            thread.setName("SyslogServer: " + protocol);
            thread.setDaemon(server.getConfig().isUseDaemonThread());
            if (server.getConfig().getThreadPriority() > -1) {
                thread.setPriority(server.getConfig().getThreadPriority());
            }
            server.setThread(thread);
            thread.start();
        }
        return server;
    }

    public static final boolean exists(String protocol) {
        if (protocol == null || "".equals(protocol.trim())) {
            return false;
        }
        return instances.containsKey(protocol.toLowerCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final SyslogServerIF createInstance(String protocol, SyslogServerConfigIF config) throws SyslogRuntimeException {
        if (protocol == null || "".equals(protocol.trim())) {
            SyslogServer.throwRuntimeException("Instance protocol cannot be null or empty");
            return null;
        }
        if (config == null) {
            SyslogServer.throwRuntimeException("SyslogServerConfig cannot be null");
            return null;
        }
        String syslogProtocol = protocol.toLowerCase();
        SyslogServerIF syslogServer = null;
        Map map2 = instances;
        synchronized (map2) {
            if (instances.containsKey(syslogProtocol)) {
                SyslogServer.throwRuntimeException("SyslogServer instance \"" + syslogProtocol + "\" already defined.");
                return null;
            }
            try {
                Class syslogClass = config.getSyslogServerClass();
                syslogServer = (SyslogServerIF)syslogClass.newInstance();
            }
            catch (ClassCastException cse) {
                throw new SyslogRuntimeException(cse);
            }
            catch (IllegalAccessException iae) {
                throw new SyslogRuntimeException(iae);
            }
            catch (InstantiationException ie) {
                throw new SyslogRuntimeException(ie);
            }
            syslogServer.initialize(syslogProtocol, config);
            instances.put(syslogProtocol, syslogServer);
        }
        return syslogServer;
    }

    public static final SyslogServerIF createThreadedInstance(String protocol, SyslogServerConfigIF config) throws SyslogRuntimeException {
        SyslogServer.createInstance(protocol, config);
        SyslogServerIF server = SyslogServer.getThreadedInstance(protocol);
        return server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final synchronized void destroyInstance(String protocol) {
        if (protocol == null || "".equals(protocol.trim())) {
            return;
        }
        String _protocol = protocol.toLowerCase();
        if (instances.containsKey(_protocol)) {
            SyslogUtility.sleep(500L);
            SyslogServerIF syslogServer = (SyslogServerIF)instances.get(_protocol);
            try {
                syslogServer.shutdown();
            }
            finally {
                instances.remove(_protocol);
            }
        } else {
            SyslogServer.throwRuntimeException("Cannot destroy server protocol \"" + protocol + "\" instance; call shutdown instead");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final synchronized void destroyInstance(SyslogServerIF syslogServer) {
        if (syslogServer == null) {
            return;
        }
        String protocol = syslogServer.getProtocol().toLowerCase();
        if (instances.containsKey(protocol)) {
            SyslogUtility.sleep(500L);
            try {
                syslogServer.shutdown();
            }
            finally {
                instances.remove(protocol);
            }
        } else {
            SyslogServer.throwRuntimeException("Cannot destroy server protocol \"" + protocol + "\" instance; call shutdown instead");
        }
    }

    public static synchronized void initialize() {
        SyslogServer.createInstance("udp", new UDPNetSyslogServerConfig());
        SyslogServer.createInstance("tcp", new TCPNetSyslogServerConfig());
    }

    public static final synchronized void shutdown() throws SyslogRuntimeException {
        Set protocols = instances.keySet();
        for (String protocol : protocols) {
            SyslogServerIF syslogServer = (SyslogServerIF)instances.get(protocol);
            syslogServer.shutdown();
        }
        instances.clear();
    }

    public static void main(String[] args) throws Exception {
        SyslogServerMain.main(args);
    }

    static {
        SyslogServer.initialize();
    }
}

