/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.syslog4j.impl.net.tcp;

import org.graylog2.syslog4j.SyslogConstants;
import org.graylog2.syslog4j.impl.net.AbstractNetSyslogConfig;
import org.graylog2.syslog4j.impl.net.tcp.TCPNetSyslog;
import org.graylog2.syslog4j.impl.net.tcp.TCPNetSyslogConfigIF;
import org.graylog2.syslog4j.impl.net.tcp.TCPNetSyslogWriter;
import org.graylog2.syslog4j.util.SyslogUtility;

public class TCPNetSyslogConfig
extends AbstractNetSyslogConfig
implements TCPNetSyslogConfigIF {
    private static final long serialVersionUID = 9023152050686365460L;
    public static byte[] SYSTEM_DELIMITER_SEQUENCE = null;
    protected byte[] delimiterSequence = SYSTEM_DELIMITER_SEQUENCE;
    protected boolean persistentConnection = true;
    protected boolean soLinger = true;
    protected int soLingerSeconds = 1;
    protected boolean keepAlive = true;
    protected boolean reuseAddress = true;
    protected boolean setBufferSize = true;
    protected int freshConnectionInterval = -1;

    public TCPNetSyslogConfig() {
        this.initialize();
    }

    protected void initialize() {
    }

    public TCPNetSyslogConfig(int facility, String host, int port) {
        super(facility, host, port);
        this.initialize();
    }

    public TCPNetSyslogConfig(int facility, String host) {
        super(facility, host);
        this.initialize();
    }

    public TCPNetSyslogConfig(int facility) {
        super(facility);
        this.initialize();
    }

    public TCPNetSyslogConfig(String host, int port) {
        super(host, port);
        this.initialize();
    }

    public TCPNetSyslogConfig(String host) {
        super(host);
        this.initialize();
    }

    public Class getSyslogClass() {
        return TCPNetSyslog.class;
    }

    public byte[] getDelimiterSequence() {
        return this.delimiterSequence;
    }

    public void setDelimiterSequence(byte[] delimiterSequence) {
        this.delimiterSequence = delimiterSequence;
    }

    public void setDelimiterSequence(String delimiterSequence) {
        this.delimiterSequence = SyslogUtility.getBytes(this, delimiterSequence);
    }

    public boolean isPersistentConnection() {
        return this.persistentConnection;
    }

    public void setPersistentConnection(boolean persistentConnection) {
        this.persistentConnection = persistentConnection;
    }

    public boolean isSoLinger() {
        return this.soLinger;
    }

    public void setSoLinger(boolean soLinger) {
        this.soLinger = soLinger;
    }

    public int getSoLingerSeconds() {
        return this.soLingerSeconds;
    }

    public void setSoLingerSeconds(int soLingerSeconds) {
        this.soLingerSeconds = soLingerSeconds;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public boolean isReuseAddress() {
        return this.reuseAddress;
    }

    public void setReuseAddress(boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
    }

    public boolean isSetBufferSize() {
        return this.setBufferSize;
    }

    public void setSetBufferSize(boolean setBufferSize) {
        this.setBufferSize = setBufferSize;
    }

    public int getFreshConnectionInterval() {
        return this.freshConnectionInterval;
    }

    public void setFreshConnectionInterval(int freshConnectionInterval) {
        this.freshConnectionInterval = freshConnectionInterval;
    }

    public Class getSyslogWriterClass() {
        return TCPNetSyslogWriter.class;
    }

    static {
        String delimiterSequence = System.getProperty("line.separator");
        SYSTEM_DELIMITER_SEQUENCE = delimiterSequence.getBytes();
        if (SYSTEM_DELIMITER_SEQUENCE == null || SYSTEM_DELIMITER_SEQUENCE.length < 1) {
            SYSTEM_DELIMITER_SEQUENCE = SyslogConstants.TCP_DELIMITER_SEQUENCE_DEFAULT;
        }
    }
}

