/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.syslog4j.impl.multiple;

import org.graylog2.syslog4j.Syslog;
import org.graylog2.syslog4j.SyslogConfigIF;
import org.graylog2.syslog4j.SyslogIF;
import org.graylog2.syslog4j.SyslogMessageIF;
import org.graylog2.syslog4j.SyslogMessageProcessorIF;
import org.graylog2.syslog4j.SyslogRuntimeException;
import org.graylog2.syslog4j.impl.multiple.MultipleSyslogConfig;

public class MultipleSyslog
implements SyslogIF {
    private static final long serialVersionUID = 587308197526365108L;
    protected String syslogProtocol = null;
    protected MultipleSyslogConfig multipleSyslogConfig = null;

    public void initialize(String protocol, SyslogConfigIF config) throws SyslogRuntimeException {
        this.syslogProtocol = protocol;
        try {
            this.multipleSyslogConfig = (MultipleSyslogConfig)config;
        }
        catch (ClassCastException cce) {
            throw new SyslogRuntimeException("config must be of type MultipleSyslogConfig");
        }
    }

    public SyslogConfigIF getConfig() {
        return this.multipleSyslogConfig;
    }

    public void debug(String message) {
        this.log(7, message);
    }

    public void debug(SyslogMessageIF message) {
        this.log(7, message);
    }

    public void critical(String message) {
        this.log(2, message);
    }

    public void critical(SyslogMessageIF message) {
        this.log(2, message);
    }

    public void error(String message) {
        this.log(3, message);
    }

    public void error(SyslogMessageIF message) {
        this.log(3, message);
    }

    public void alert(String message) {
        this.log(1, message);
    }

    public void alert(SyslogMessageIF message) {
        this.log(1, message);
    }

    public void notice(String message) {
        this.log(5, message);
    }

    public void notice(SyslogMessageIF message) {
        this.log(5, message);
    }

    public void emergency(String message) {
        this.log(0, message);
    }

    public void emergency(SyslogMessageIF message) {
        this.log(0, message);
    }

    public void info(String message) {
        this.log(6, message);
    }

    public void info(SyslogMessageIF message) {
        this.log(6, message);
    }

    public void warn(String message) {
        this.log(4, message);
    }

    public void warn(SyslogMessageIF message) {
        this.log(4, message);
    }

    public void log(int level, String message) {
        for (int i = 0; i < this.multipleSyslogConfig.getProtocols().size(); ++i) {
            String protocol = (String)this.multipleSyslogConfig.getProtocols().get(i);
            SyslogIF syslog = Syslog.getInstance(protocol);
            syslog.log(level, message);
        }
    }

    public void log(int level, SyslogMessageIF message) {
        for (int i = 0; i < this.multipleSyslogConfig.getProtocols().size(); ++i) {
            String protocol = (String)this.multipleSyslogConfig.getProtocols().get(i);
            SyslogIF syslog = Syslog.getInstance(protocol);
            syslog.log(level, message);
        }
    }

    public void flush() throws SyslogRuntimeException {
        for (int i = 0; i < this.multipleSyslogConfig.getProtocols().size(); ++i) {
            String protocol = (String)this.multipleSyslogConfig.getProtocols().get(i);
            SyslogIF syslog = Syslog.getInstance(protocol);
            syslog.flush();
        }
    }

    public void shutdown() throws SyslogRuntimeException {
        for (int i = 0; i < this.multipleSyslogConfig.getProtocols().size(); ++i) {
            String protocol = (String)this.multipleSyslogConfig.getProtocols().get(i);
            SyslogIF syslog = Syslog.getInstance(protocol);
            syslog.shutdown();
        }
    }

    public void backLog(int level, String message, Throwable reasonThrowable) {
    }

    public void backLog(int level, String message, String reason) {
    }

    public void setMessageProcessor(SyslogMessageProcessorIF messageProcessor) {
        throw new SyslogRuntimeException("MultipleSyslog is an aggregator; please set the individual protocols");
    }

    public SyslogMessageProcessorIF getMessageProcessor() {
        throw new SyslogRuntimeException("MultipleSyslog is an aggregator; please set the individual protocols");
    }

    public void setStructuredMessageProcessor(SyslogMessageProcessorIF messageProcessor) {
        throw new SyslogRuntimeException("MultipleSyslog is an aggregator; please set the individual protocols");
    }

    public SyslogMessageProcessorIF getStructuredMessageProcessor() {
        throw new SyslogRuntimeException("MultipleSyslog is an aggregator; please set the individual protocols");
    }

    public String getProtocol() {
        return this.syslogProtocol;
    }
}

