/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.syslog4j.impl.message.modifier.sequential;

import org.graylog2.syslog4j.SyslogIF;
import org.graylog2.syslog4j.SyslogMessageModifierIF;
import org.graylog2.syslog4j.impl.message.modifier.sequential.SequentialSyslogMessageModifierConfig;

public class SequentialSyslogMessageModifier
implements SyslogMessageModifierIF {
    private static final long serialVersionUID = 6107735010240030785L;
    protected SequentialSyslogMessageModifierConfig config = null;
    protected long[] currentSequence = new long[8];

    public static final SequentialSyslogMessageModifier createDefault() {
        SequentialSyslogMessageModifier modifier = new SequentialSyslogMessageModifier(SequentialSyslogMessageModifierConfig.createDefault());
        return modifier;
    }

    public SequentialSyslogMessageModifier(SequentialSyslogMessageModifierConfig config) {
        this.config = config;
        for (int i = 0; i < 8; ++i) {
            this.currentSequence[i] = config.getFirstNumber();
        }
    }

    protected String pad(long number2) {
        StringBuffer buffer = new StringBuffer(Long.toString(number2));
        while ((long)buffer.length() < this.config.getLastNumberDigits()) {
            buffer.insert(0, this.config.getPadChar());
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNextSequence(int level, long nextSequence) {
        if (nextSequence >= this.config.getFirstNumber() && nextSequence < this.config.getLastNumber()) {
            SequentialSyslogMessageModifier sequentialSyslogMessageModifier = this;
            synchronized (sequentialSyslogMessageModifier) {
                this.currentSequence[level] = nextSequence;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String nextSequence(int level) {
        long sequence2 = -1L;
        SequentialSyslogMessageModifier sequentialSyslogMessageModifier = this;
        synchronized (sequentialSyslogMessageModifier) {
            sequence2 = this.currentSequence[level];
            if (this.currentSequence[level] >= this.config.getLastNumber()) {
                this.currentSequence[level] = this.config.getFirstNumber();
            } else {
                int n = level;
                this.currentSequence[n] = this.currentSequence[n] + 1L;
            }
        }
        String _sequence = null;
        _sequence = this.config.isUsePadding() ? this.pad(sequence2) : Long.toString(sequence2);
        return _sequence;
    }

    public SequentialSyslogMessageModifierConfig getConfig() {
        return this.config;
    }

    public String modify(SyslogIF syslog, int facility, int level, String message) {
        StringBuffer buffer = new StringBuffer(message);
        buffer.append(this.config.getPrefix());
        buffer.append(this.nextSequence(level));
        buffer.append(this.config.getSuffix());
        return buffer.toString();
    }

    public boolean verify(String message) {
        return true;
    }
}

