/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.syslog4j.impl;

import java.util.ArrayList;
import java.util.List;
import org.graylog2.syslog4j.SyslogBackLogHandlerIF;
import org.graylog2.syslog4j.SyslogConfigIF;
import org.graylog2.syslog4j.SyslogIF;
import org.graylog2.syslog4j.SyslogMessageIF;
import org.graylog2.syslog4j.SyslogMessageModifierIF;
import org.graylog2.syslog4j.SyslogMessageProcessorIF;
import org.graylog2.syslog4j.SyslogRuntimeException;
import org.graylog2.syslog4j.impl.AbstractSyslogConfigIF;
import org.graylog2.syslog4j.impl.AbstractSyslogWriter;
import org.graylog2.syslog4j.impl.message.processor.SyslogMessageProcessor;
import org.graylog2.syslog4j.impl.message.processor.structured.StructuredSyslogMessageProcessor;
import org.graylog2.syslog4j.impl.message.structured.StructuredSyslogMessage;
import org.graylog2.syslog4j.impl.message.structured.StructuredSyslogMessageIF;
import org.graylog2.syslog4j.util.SyslogUtility;

public abstract class AbstractSyslog
implements SyslogIF {
    private static final long serialVersionUID = 2632017043774808264L;
    protected String syslogProtocol = null;
    protected AbstractSyslogConfigIF syslogConfig = null;
    protected SyslogMessageProcessorIF syslogMessageProcessor = null;
    protected SyslogMessageProcessorIF structuredSyslogMessageProcessor = null;
    protected Object backLogStatusSyncObject = new Object();
    protected boolean backLogStatus = false;
    protected List notifiedBackLogHandlers = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean getBackLogStatus() {
        Object object = this.backLogStatusSyncObject;
        synchronized (object) {
            return this.backLogStatus;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBackLogStatus(boolean backLogStatus) {
        if (this.backLogStatus != backLogStatus) {
            Object object = this.backLogStatusSyncObject;
            synchronized (object) {
                if (!backLogStatus) {
                    for (int i = 0; i < this.notifiedBackLogHandlers.size(); ++i) {
                        SyslogBackLogHandlerIF backLogHandler = (SyslogBackLogHandlerIF)this.notifiedBackLogHandlers.get(i);
                        backLogHandler.up(this);
                    }
                    this.notifiedBackLogHandlers.clear();
                }
                this.backLogStatus = backLogStatus;
            }
        }
    }

    public void initialize(String protocol, SyslogConfigIF config) throws SyslogRuntimeException {
        this.syslogProtocol = protocol;
        try {
            this.syslogConfig = (AbstractSyslogConfigIF)config;
        }
        catch (ClassCastException cce) {
            throw new SyslogRuntimeException("provided config must implement AbstractSyslogConfigIF");
        }
        this.initialize();
    }

    public SyslogMessageProcessorIF getMessageProcessor() {
        if (this.syslogMessageProcessor == null) {
            this.syslogMessageProcessor = SyslogMessageProcessor.getDefault();
        }
        return this.syslogMessageProcessor;
    }

    public SyslogMessageProcessorIF getStructuredMessageProcessor() {
        if (this.structuredSyslogMessageProcessor == null) {
            this.structuredSyslogMessageProcessor = StructuredSyslogMessageProcessor.getDefault();
        }
        return this.structuredSyslogMessageProcessor;
    }

    public void setMessageProcessor(SyslogMessageProcessorIF messageProcessor) {
        this.syslogMessageProcessor = messageProcessor;
    }

    public void setStructuredMessageProcessor(SyslogMessageProcessorIF messageProcessor) {
        this.structuredSyslogMessageProcessor = messageProcessor;
    }

    public String getProtocol() {
        return this.syslogProtocol;
    }

    public SyslogConfigIF getConfig() {
        return this.syslogConfig;
    }

    public void log(int level, String message) {
        if (this.syslogConfig.isUseStructuredData()) {
            StructuredSyslogMessage structuredMessage = new StructuredSyslogMessage(null, null, message);
            this.log(this.getStructuredMessageProcessor(), level, structuredMessage.createMessage());
        } else {
            this.log(this.getMessageProcessor(), level, message);
        }
    }

    public void log(int level, SyslogMessageIF message) {
        if (message instanceof StructuredSyslogMessageIF) {
            if (this.getMessageProcessor() instanceof StructuredSyslogMessageProcessor) {
                this.log(this.getMessageProcessor(), level, message.createMessage());
            } else {
                this.log(this.getStructuredMessageProcessor(), level, message.createMessage());
            }
        } else {
            this.log(this.getMessageProcessor(), level, message.createMessage());
        }
    }

    public void debug(String message) {
        this.log(7, message);
    }

    public void notice(String message) {
        this.log(5, message);
    }

    public void info(String message) {
        this.log(6, message);
    }

    public void warn(String message) {
        this.log(4, message);
    }

    public void error(String message) {
        this.log(3, message);
    }

    public void critical(String message) {
        this.log(2, message);
    }

    public void alert(String message) {
        this.log(1, message);
    }

    public void emergency(String message) {
        this.log(0, message);
    }

    public void debug(SyslogMessageIF message) {
        this.log(7, message);
    }

    public void notice(SyslogMessageIF message) {
        this.log(5, message);
    }

    public void info(SyslogMessageIF message) {
        this.log(6, message);
    }

    public void warn(SyslogMessageIF message) {
        this.log(4, message);
    }

    public void error(SyslogMessageIF message) {
        this.log(3, message);
    }

    public void critical(SyslogMessageIF message) {
        this.log(2, message);
    }

    public void alert(SyslogMessageIF message) {
        this.log(1, message);
    }

    public void emergency(SyslogMessageIF message) {
        this.log(0, message);
    }

    protected String prefixMessage(String message, String suffix) {
        String ident2 = this.syslogConfig.getIdent();
        String _message = (ident2 == null || "".equals(ident2.trim()) ? "" : ident2 + suffix) + message;
        return _message;
    }

    public void log(SyslogMessageProcessorIF messageProcessor, int level, String message) {
        block6: {
            String _message = null;
            if (this.syslogConfig.isIncludeIdentInMessageModifier()) {
                _message = this.prefixMessage(message, ": ");
                _message = this.modifyMessage(level, _message);
            } else {
                _message = this.modifyMessage(level, message);
                _message = this.prefixMessage(_message, ": ");
            }
            try {
                this.write(messageProcessor, level, _message);
            }
            catch (SyslogRuntimeException sre) {
                if (sre.getCause() != null) {
                    this.backLog(level, _message, sre.getCause());
                } else {
                    this.backLog(level, _message, sre);
                }
                if (!this.syslogConfig.isThrowExceptionOnWrite()) break block6;
                throw sre;
            }
        }
    }

    protected void write(SyslogMessageProcessorIF messageProcessor, int level, String message) throws SyslogRuntimeException {
        String header = messageProcessor.createSyslogHeader(this.syslogConfig.getFacility(), level, this.syslogConfig.getLocalName(), this.syslogConfig.isSendLocalTimestamp(), this.syslogConfig.isSendLocalName());
        byte[] h = SyslogUtility.getBytes(this.syslogConfig, header);
        byte[] m = SyslogUtility.getBytes(this.syslogConfig, message);
        int mLength = m.length;
        int availableLen = this.syslogConfig.getMaxMessageLength() - h.length;
        if (this.syslogConfig.isTruncateMessage() && availableLen > 0 && mLength > availableLen) {
            mLength = availableLen;
        }
        if (mLength <= availableLen) {
            byte[] data2 = messageProcessor.createPacketData(h, m, 0, mLength);
            this.write(level, data2);
        } else {
            int actualAvailableLen;
            byte[] splitBeginText = this.syslogConfig.getSplitMessageBeginText();
            byte[] splitEndText = this.syslogConfig.getSplitMessageEndText();
            int pos = 0;
            for (int left = mLength; left > 0; left -= actualAvailableLen) {
                boolean firstTime = pos == 0;
                boolean doSplitBeginText = splitBeginText != null && !firstTime;
                boolean doSplitEndText = splitBeginText != null && (firstTime || left > availableLen - splitBeginText.length);
                actualAvailableLen = availableLen;
                actualAvailableLen -= splitBeginText != null && doSplitBeginText ? splitBeginText.length : 0;
                if ((actualAvailableLen -= splitEndText != null && doSplitEndText ? splitEndText.length : 0) > left) {
                    actualAvailableLen = left;
                }
                if (actualAvailableLen < 0) {
                    throw new SyslogRuntimeException("Message length < 0; recommendation: increase the size of maxMessageLength");
                }
                byte[] data3 = messageProcessor.createPacketData(h, m, pos, actualAvailableLen, (byte[])(doSplitBeginText ? splitBeginText : null), (byte[])(doSplitEndText ? splitEndText : null));
                this.write(level, data3);
                pos += actualAvailableLen;
            }
        }
    }

    protected abstract void initialize() throws SyslogRuntimeException;

    protected abstract void write(int var1, byte[] var2) throws SyslogRuntimeException;

    protected String modifyMessage(int level, String message) {
        List _messageModifiers = this.syslogConfig.getMessageModifiers();
        if (_messageModifiers == null || _messageModifiers.size() < 1) {
            return message;
        }
        String _message = message;
        int facility = this.syslogConfig.getFacility();
        for (int i = 0; i < _messageModifiers.size(); ++i) {
            SyslogMessageModifierIF messageModifier = (SyslogMessageModifierIF)_messageModifiers.get(i);
            _message = messageModifier.modify(this, facility, level, _message);
        }
        return _message;
    }

    public void backLog(int level, String message, Throwable reasonThrowable) {
        this.backLog(level, message, reasonThrowable != null ? reasonThrowable.toString() : "UNKNOWN");
    }

    public void backLog(int level, String message, String reason) {
        boolean status = this.getBackLogStatus();
        if (!status) {
            this.setBackLogStatus(true);
        }
        List backLogHandlers = this.syslogConfig.getBackLogHandlers();
        for (int i = 0; i < backLogHandlers.size(); ++i) {
            SyslogBackLogHandlerIF backLogHandler = (SyslogBackLogHandlerIF)backLogHandlers.get(i);
            try {
                if (!status) {
                    backLogHandler.down(this, reason);
                    this.notifiedBackLogHandlers.add(backLogHandler);
                }
                backLogHandler.log(this, level, message, reason);
                break;
            }
            catch (Exception e) {
                continue;
            }
        }
    }

    public abstract AbstractSyslogWriter getWriter();

    public abstract void returnWriter(AbstractSyslogWriter var1);

    public Thread createWriterThread(AbstractSyslogWriter syslogWriter) {
        Thread newWriterThread = new Thread(syslogWriter);
        newWriterThread.setName("SyslogWriter: " + this.getProtocol());
        newWriterThread.setDaemon(this.syslogConfig.isUseDaemonThread());
        if (this.syslogConfig.getThreadPriority() > -1) {
            newWriterThread.setPriority(this.syslogConfig.getThreadPriority());
        }
        syslogWriter.setThread(newWriterThread);
        newWriterThread.start();
        return newWriterThread;
    }

    public AbstractSyslogWriter createWriter() {
        AbstractSyslogWriter newWriter;
        block4: {
            Class clazz = this.syslogConfig.getSyslogWriterClass();
            newWriter = null;
            try {
                newWriter = (AbstractSyslogWriter)clazz.newInstance();
                newWriter.initialize(this);
            }
            catch (InstantiationException ie) {
                if (this.syslogConfig.isThrowExceptionOnInitialize()) {
                    throw new SyslogRuntimeException(ie);
                }
            }
            catch (IllegalAccessException iae) {
                if (!this.syslogConfig.isThrowExceptionOnInitialize()) break block4;
                throw new SyslogRuntimeException(iae);
            }
        }
        return newWriter;
    }
}

