/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.syslog4j;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.graylog2.syslog4j.SyslogConfigIF;
import org.graylog2.syslog4j.SyslogConstants;
import org.graylog2.syslog4j.SyslogIF;
import org.graylog2.syslog4j.SyslogMain;
import org.graylog2.syslog4j.SyslogRuntimeException;
import org.graylog2.syslog4j.impl.net.tcp.TCPNetSyslogConfig;
import org.graylog2.syslog4j.impl.net.udp.UDPNetSyslogConfig;
import org.graylog2.syslog4j.impl.unix.UnixSyslogConfig;
import org.graylog2.syslog4j.impl.unix.socket.UnixSocketSyslogConfig;
import org.graylog2.syslog4j.util.OSDetectUtility;
import org.graylog2.syslog4j.util.SyslogUtility;

public final class Syslog
implements SyslogConstants {
    private static final long serialVersionUID = -4662318148650646144L;
    private static boolean SUPPRESS_RUNTIME_EXCEPTIONS = false;
    protected static final Map instances = new Hashtable();

    private Syslog() {
    }

    public static final String getVersion() {
        return "Syslog4j-graylog2 0.9.48 kroepke";
    }

    public static void setSuppressRuntimeExceptions(boolean suppress) {
        SUPPRESS_RUNTIME_EXCEPTIONS = suppress;
    }

    public static boolean getSuppressRuntimeExceptions() {
        return SUPPRESS_RUNTIME_EXCEPTIONS;
    }

    private static void throwRuntimeException(String message) throws SyslogRuntimeException {
        if (SUPPRESS_RUNTIME_EXCEPTIONS) {
            return;
        }
        throw new SyslogRuntimeException(message.toString());
    }

    public static final SyslogIF getInstance(String protocol) throws SyslogRuntimeException {
        String _protocol = protocol.toLowerCase();
        if (instances.containsKey(_protocol)) {
            return (SyslogIF)instances.get(_protocol);
        }
        StringBuffer message = new StringBuffer("Syslog protocol \"" + protocol + "\" not defined; call Syslogger.createSyslogInstance(protocol,config) first");
        if (instances.size() > 0) {
            message.append(" or use one of the following instances: ");
            Iterator i = instances.keySet().iterator();
            while (i.hasNext()) {
                String k = (String)i.next();
                message.append(k);
                if (!i.hasNext()) continue;
                message.append(' ');
            }
        }
        Syslog.throwRuntimeException(message.toString());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final SyslogIF createInstance(String protocol, SyslogConfigIF config) throws SyslogRuntimeException {
        if (protocol == null || "".equals(protocol.trim())) {
            Syslog.throwRuntimeException("Instance protocol cannot be null or empty");
            return null;
        }
        if (config == null) {
            Syslog.throwRuntimeException("SyslogConfig cannot be null");
            return null;
        }
        String syslogProtocol = protocol.toLowerCase();
        SyslogIF syslog = null;
        Map map2 = instances;
        synchronized (map2) {
            if (instances.containsKey(syslogProtocol)) {
                Syslog.throwRuntimeException("Syslog protocol \"" + protocol + "\" already defined");
                return null;
            }
            try {
                Class syslogClass = config.getSyslogClass();
                syslog = (SyslogIF)syslogClass.newInstance();
            }
            catch (ClassCastException cse) {
                if (!config.isThrowExceptionOnInitialize()) {
                    throw new SyslogRuntimeException(cse);
                }
                return null;
            }
            catch (IllegalAccessException iae) {
                if (!config.isThrowExceptionOnInitialize()) {
                    throw new SyslogRuntimeException(iae);
                }
                return null;
            }
            catch (InstantiationException ie) {
                if (!config.isThrowExceptionOnInitialize()) {
                    throw new SyslogRuntimeException(ie);
                }
                return null;
            }
            syslog.initialize(syslogProtocol, config);
            instances.put(syslogProtocol, syslog);
        }
        return syslog;
    }

    public static final synchronized void initialize() {
        Syslog.createInstance("udp", new UDPNetSyslogConfig());
        Syslog.createInstance("tcp", new TCPNetSyslogConfig());
        if (OSDetectUtility.isUnix() && SyslogUtility.isClassExists("com.sun.jna.Native")) {
            Syslog.createInstance("unix_syslog", new UnixSyslogConfig());
            Syslog.createInstance("unix_socket", new UnixSocketSyslogConfig());
        }
    }

    public static final boolean exists(String protocol) {
        if (protocol == null || "".equals(protocol.trim())) {
            return false;
        }
        return instances.containsKey(protocol.toLowerCase());
    }

    public static final synchronized void shutdown() {
        Set protocols = instances.keySet();
        if (protocols.size() > 0) {
            Iterator i = protocols.iterator();
            SyslogUtility.sleep(500L);
            while (i.hasNext()) {
                String protocol = (String)i.next();
                SyslogIF syslog = (SyslogIF)instances.get(protocol);
                syslog.shutdown();
            }
            instances.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final synchronized void destroyInstance(String protocol) throws SyslogRuntimeException {
        if (protocol == null || "".equals(protocol.trim())) {
            return;
        }
        String _protocol = protocol.toLowerCase();
        if (instances.containsKey(_protocol)) {
            SyslogUtility.sleep(500L);
            SyslogIF syslog = (SyslogIF)instances.get(_protocol);
            try {
                syslog.shutdown();
            }
            finally {
                instances.remove(_protocol);
            }
        } else {
            Syslog.throwRuntimeException("Cannot destroy protocol \"" + protocol + "\" instance; call shutdown instead");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final synchronized void destroyInstance(SyslogIF syslog) throws SyslogRuntimeException {
        if (syslog == null) {
            return;
        }
        String protocol = syslog.getProtocol().toLowerCase();
        if (instances.containsKey(protocol)) {
            try {
                syslog.shutdown();
            }
            finally {
                instances.remove(protocol);
            }
        } else {
            Syslog.throwRuntimeException("Cannot destroy protocol \"" + protocol + "\" instance; call shutdown instead");
            return;
        }
    }

    public static void main(String[] args) throws Exception {
        SyslogMain.main(args);
    }

    static {
        Syslog.initialize();
    }
}

