/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.stats;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.cliffc.high_scale_lib.Counter;

public class ThroughputStats {
    private long currentThroughput = 0L;
    private final Counter throughputCounter = new Counter();
    private final Counter benchmarkCounter = new Counter();
    private final AtomicReference<ConcurrentHashMap<String, Counter>> streamThroughput = new AtomicReference(new ConcurrentHashMap());
    private final AtomicReference<HashMap<String, Counter>> currentStreamThroughput = new AtomicReference();

    public long getCurrentThroughput() {
        return this.currentThroughput;
    }

    public Counter getThroughputCounter() {
        return this.throughputCounter;
    }

    public Counter getBenchmarkCounter() {
        return this.benchmarkCounter;
    }

    public void setCurrentThroughput(long currentThroughput) {
        this.currentThroughput = currentThroughput;
    }

    public AtomicReference<ConcurrentHashMap<String, Counter>> getStreamThroughput() {
        return this.streamThroughput;
    }

    public Map<String, Counter> cycleStreamThroughput() {
        return this.streamThroughput.getAndSet(new ConcurrentHashMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementStreamThroughput(String streamId) {
        Counter counter;
        ConcurrentHashMap<String, Counter> counterMap;
        ConcurrentHashMap<String, Counter> concurrentHashMap = counterMap = this.streamThroughput.get();
        synchronized (concurrentHashMap) {
            counter = counterMap.get(streamId);
            if (counter == null) {
                counter = new Counter();
                counterMap.put(streamId, counter);
            }
        }
        counter.increment();
    }

    public void setCurrentStreamThroughput(HashMap<String, Counter> throughput) {
        this.currentStreamThroughput.set(throughput);
    }

    public HashMap<String, Counter> getCurrentStreamThroughput() {
        return this.currentStreamThroughput.get();
    }
}

