/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import org.graylog2.shared.rest.RangeJsonSerializer;

@Provider
public class ObjectMapperProvider
implements ContextResolver<ObjectMapper> {
    private final ObjectMapper objectMapper = new ObjectMapper();

    public ObjectMapperProvider() {
        this.objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        this.objectMapper.setPropertyNamingStrategy(new PreserveLeadingUnderscoreStrategy());
        this.objectMapper.registerModule(new JodaModule());
        this.objectMapper.registerModule(new GuavaModule());
        SimpleModule module = new SimpleModule(){
            {
                this.addSerializer(new RangeJsonSerializer());
            }
        };
        this.objectMapper.registerModule(module);
    }

    @Override
    public ObjectMapper getContext(Class<?> type) {
        return this.objectMapper;
    }

    public class PreserveLeadingUnderscoreStrategy
    extends PropertyNamingStrategy.LowerCaseWithUnderscoresStrategy {
        @Override
        public String translate(String input2) {
            String translated = super.translate(input2);
            if (input2.startsWith("_") && !translated.startsWith("_")) {
                translated = "_" + translated;
            }
            return translated;
        }
    }
}

