/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.plugins;

import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.graylog2.plugin.Plugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginLoader {
    private static final Logger LOG = LoggerFactory.getLogger(PluginLoader.class);
    public static final String GRAYLOG2_PLUGIN_PROPERTIES = "graylog2-plugin.properties";
    private final File pluginDir;

    public PluginLoader(File pluginDir) {
        this.pluginDir = pluginDir;
    }

    public Set<Plugin> loadPlugins() {
        HashSet<Plugin> plugins = Sets.newHashSet();
        plugins.addAll(this.loadClassPathPlugins());
        plugins.addAll(this.loadJarPlugins());
        return plugins;
    }

    private Set<Plugin> loadClassPathPlugins() {
        HashSet<Plugin> plugins = Sets.newHashSet();
        ClassLoader cl = this.getClass().getClassLoader();
        Set<Class<? extends Plugin>> classes = this.loadPluginClasses(cl);
        for (Class<? extends Plugin> pluginClass : classes) {
            Plugin plugin = this.instantiatePlugin(pluginClass);
            if (plugin == null) continue;
            plugins.add(plugin);
        }
        return plugins;
    }

    public Set<Plugin> loadJarPlugins() {
        HashSet<Plugin> plugins = Sets.newHashSet();
        if (!this.pluginDir.exists()) {
            LOG.warn("Plugin directory {} does not exist, not loading plugins.", (Object)this.pluginDir.getAbsolutePath());
            return plugins;
        }
        if (!this.pluginDir.isDirectory()) {
            LOG.warn("Path {} is not a directory, cannot load plugins.", (Object)this.pluginDir);
            return plugins;
        }
        ClassLoader classLoader = this.getClass().getClassLoader();
        LOG.debug("Scanning directory <{}> for plugins...", (Object)this.pluginDir.getAbsolutePath());
        File[] files = this.pluginDir.listFiles();
        LOG.debug("Loading [{}] plugins", (Object)files.length);
        for (File jar : files) {
            try {
                LOG.debug("Loading <" + jar.getAbsolutePath() + ">");
                URLClassLoader pluginClassLoader = new URLClassLoader(new URL[]{jar.toURI().toURL()}, classLoader);
                Set<Class<? extends Plugin>> pluginClasses = this.loadPluginClasses(pluginClassLoader);
                for (Class<? extends Plugin> pluginClass : pluginClasses) {
                    LOG.debug("Found plugin " + pluginClass);
                    Plugin plugin = this.instantiatePlugin(pluginClass);
                    if (plugin == null) continue;
                    plugins.add(plugin);
                }
            }
            catch (MalformedURLException e) {
                LOG.error("Cannot open jar for discovering plugins", e);
            }
        }
        return plugins;
    }

    private Set<Class<? extends Plugin>> loadPluginClasses(ClassLoader cl) {
        Enumeration<URL> urls;
        HashSet<Class<? extends Plugin>> pluginClasses = Sets.newHashSet();
        try {
            urls = cl.getResources(GRAYLOG2_PLUGIN_PROPERTIES);
        }
        catch (IOException e) {
            LOG.error("Unable to read resources from class loader", e);
            return pluginClasses;
        }
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            Properties properties = new Properties();
            try {
                InputStream inputStream = url.openStream();
                properties.load(inputStream);
            }
            catch (IOException e) {
                LOG.error("Unable to read plugin properties file", e);
            }
            String pluginClassName = properties.getProperty("plugin");
            LOG.debug("Plugin class name is {}", (Object)pluginClassName);
            if (pluginClassName == null) {
                LOG.error("Missing plugin property in property descriptor file: {}", (Object)url);
                continue;
            }
            try {
                Class<?> pluginClass = cl.loadClass(pluginClassName);
                pluginClasses.add(pluginClass);
            }
            catch (ClassNotFoundException e) {
                LOG.error("Unable to find plugin class {}, skipping.", (Object)pluginClasses);
            }
        }
        return pluginClasses;
    }

    public Plugin instantiatePlugin(Class<? extends Plugin> pluginClass) {
        Plugin plugin;
        try {
            plugin = pluginClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            LOG.error("Cannot find constructor for plugin " + pluginClass.getCanonicalName() + ". It must have a public no-args constructor.", e);
            return null;
        }
        return plugin;
    }
}

