/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.metrics.jersey2;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.annotation.ExceptionMetered;
import com.codahale.metrics.annotation.Metered;
import com.codahale.metrics.annotation.Timed;
import java.lang.reflect.Method;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.ext.Provider;
import org.graylog2.shared.metrics.jersey2.ExceptionMeteredMetricsFilter;
import org.graylog2.shared.metrics.jersey2.MeteredMetricsFilter;
import org.graylog2.shared.metrics.jersey2.TimedMetricsFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class MetricsDynamicBinding
implements DynamicFeature {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsDynamicBinding.class);
    private final MetricRegistry metricRegistry;

    public MetricsDynamicBinding(@Context MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
    }

    @Override
    public void configure(ResourceInfo resourceInfo, FeatureContext context) {
        Method resourceMethod = resourceInfo.getResourceMethod();
        if (resourceMethod.isAnnotationPresent(Timed.class)) {
            LOG.debug("Setting up filter for Timed resource method: {}#{}", (Object)resourceInfo.getResourceClass().getCanonicalName(), (Object)resourceMethod.getName());
            context.register(new TimedMetricsFilter(this.metricRegistry, resourceInfo));
        }
        if (resourceMethod.isAnnotationPresent(Metered.class)) {
            LOG.debug("Setting up filter for Metered resource method: {}#{}", (Object)resourceInfo.getResourceClass().getCanonicalName(), (Object)resourceMethod.getName());
            context.register(new MeteredMetricsFilter(this.metricRegistry, resourceInfo));
        }
        if (resourceMethod.isAnnotationPresent(ExceptionMetered.class)) {
            LOG.debug("Setting up filter for ExceptionMetered resource method: {}#{}", (Object)resourceInfo.getResourceClass().getCanonicalName(), (Object)resourceMethod.getName());
            context.register(new ExceptionMeteredMetricsFilter(this.metricRegistry, resourceInfo));
        }
    }
}

