/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.inputs;

import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.graylog2.plugin.inputs.InputState;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.plugin.inputs.MisfireException;
import org.graylog2.shared.buffers.ProcessBuffer;
import org.graylog2.shared.inputs.MessageInputFactory;
import org.graylog2.shared.inputs.NoSuchInputTypeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InputRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(InputRegistry.class);
    protected final Set<InputState> inputStates = new HashSet<InputState>();
    protected final ExecutorService executor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("inputs-%d").build());
    private final MessageInputFactory messageInputFactory;
    private final ProcessBuffer processBuffer;

    protected abstract void finishedLaunch(InputState var1);

    protected abstract void finishedTermination(InputState var1);

    protected abstract void finishedStop(InputState var1);

    protected abstract List<MessageInput> getAllPersisted();

    public abstract void cleanInput(MessageInput var1);

    public InputRegistry(MessageInputFactory messageInputFactory, ProcessBuffer processBuffer) {
        this.messageInputFactory = messageInputFactory;
        this.processBuffer = processBuffer;
    }

    public MessageInput create(String inputClass) throws NoSuchInputTypeException {
        return this.messageInputFactory.create(inputClass);
    }

    public InputState launch(MessageInput input2, String id) {
        return this.launch(input2, id, false);
    }

    public InputState launch(MessageInput input2, String id, boolean register) {
        InputState inputState = new InputState(input2, id);
        this.inputStates.add(inputState);
        return this.launch(input2, inputState, register);
    }

    protected InputState launch(final MessageInput input2, final InputState inputState, boolean register) {
        if (input2 == null) {
            throw new IllegalArgumentException("InputState has no MessageInput!");
        }
        if (!inputState.getMessageInput().equals(input2)) {
            throw new IllegalArgumentException("Supplied InputState already has Input which is not the one supplied.");
        }
        if (inputState.getMessageInput() == null) {
            inputState.setMessageInput(input2);
        }
        this.executor.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LOG.info("Starting [{}] input with ID <{}>", (Object)input2.getClass().getCanonicalName(), (Object)input2.getId());
                try {
                    input2.checkConfiguration();
                    inputState.setState(InputState.InputStateType.STARTING);
                    input2.launch(InputRegistry.this.processBuffer);
                    inputState.setState(InputState.InputStateType.RUNNING);
                    String msg = "Completed starting [" + input2.getClass().getCanonicalName() + "] input with ID <" + input2.getId() + ">";
                    LOG.info(msg);
                }
                catch (Exception | MisfireException e) {
                    InputRegistry.this.handleLaunchException(e, input2, inputState);
                }
                finally {
                    InputRegistry.this.finishedLaunch(inputState);
                }
            }
        });
        return inputState;
    }

    protected void handleLaunchException(Throwable e, MessageInput input2, InputState inputState) {
        StringBuilder msg = new StringBuilder("The [" + input2.getClass().getCanonicalName() + "] input with ID <" + input2.getId() + "> misfired. Reason: ");
        String causeMsg = this.extractMessageCause(e);
        msg.append(causeMsg);
        LOG.error(msg.toString(), e);
        inputState.setState(InputState.InputStateType.FAILED);
        inputState.setDetailedMessage(causeMsg);
    }

    private String extractMessageCause(Throwable e) {
        StringBuilder causeMsg = new StringBuilder(e.getMessage());
        int maxLevel = 7;
        Throwable cause = e.getCause();
        for (int i = 0; i < maxLevel && cause != null; cause = cause.getCause(), ++i) {
            causeMsg.append(", ").append(cause.getMessage());
        }
        return causeMsg.toString();
    }

    public InputState launch(MessageInput input2) {
        return this.launch(input2, UUID.randomUUID().toString());
    }

    public InputState launch(InputState inputState) {
        MessageInput input2 = inputState.getMessageInput();
        return this.launch(input2, inputState, false);
    }

    public Set<InputState> getInputStates() {
        return ImmutableSet.copyOf(this.inputStates);
    }

    public InputState getInputState(String inputId) {
        for (InputState inputState : this.inputStates) {
            if (!inputState.getMessageInput().getPersistId().equals(inputId)) continue;
            return inputState;
        }
        return null;
    }

    public Set<InputState> getRunningInputs() {
        HashSet<InputState> runningInputs = new HashSet<InputState>();
        for (InputState inputState : this.inputStates) {
            if (inputState.getState() != InputState.InputStateType.RUNNING) continue;
            runningInputs.add(inputState);
        }
        return ImmutableSet.copyOf(runningInputs);
    }

    public boolean hasTypeRunning(Class klazz) {
        for (InputState inputState : this.inputStates) {
            if (!inputState.getMessageInput().getClass().equals(klazz)) continue;
            return true;
        }
        return false;
    }

    public Map<String, String> getAvailableInputs() {
        return this.messageInputFactory.getAvailableInputs();
    }

    public int runningCount() {
        return this.getRunningInputs().size();
    }

    public void removeFromRunning(MessageInput input2) {
        InputState thisInputState = null;
        for (InputState inputState : this.inputStates) {
            if (!inputState.getMessageInput().equals(input2)) continue;
            thisInputState = inputState;
        }
        this.inputStates.remove(thisInputState);
    }

    public void removeFromRunning(InputState inputState) {
        this.inputStates.remove(inputState);
    }

    public InputState launchPersisted(MessageInput input2) {
        return this.launch(input2);
    }

    public void launchAllPersisted() {
        for (MessageInput input2 : this.getAllPersisted()) {
            this.launchPersisted(input2);
        }
    }

    public InputState terminate(MessageInput input2) {
        InputState inputState = this.stop(input2);
        if (inputState != null) {
            inputState.setState(InputState.InputStateType.TERMINATED);
            this.finishedTermination(inputState);
        }
        return inputState;
    }

    public InputState stop(MessageInput input2) {
        InputState inputState = this.getRunningInputState(input2.getId());
        if (inputState != null) {
            try {
                input2.stop();
            }
            catch (Exception e) {
                LOG.warn("Stopping input <{}> failed, removing anyway: {}", (Object)input2.getId(), (Object)e);
            }
            inputState.setState(InputState.InputStateType.STOPPED);
            this.finishedStop(inputState);
        }
        return inputState;
    }

    public MessageInput getRunningInput(String inputId) {
        for (InputState inputState : this.inputStates) {
            if (!inputState.getMessageInput().getId().equals(inputId)) continue;
            return inputState.getMessageInput();
        }
        return null;
    }

    public InputState getRunningInputState(String inputStateId) {
        for (InputState inputState : this.inputStates) {
            if (!inputState.getMessageInput().getId().equals(inputStateId)) continue;
            return inputState;
        }
        return null;
    }

    public MessageInput getPersisted(String inputId) {
        for (MessageInput input2 : this.getAllPersisted()) {
            if (!input2.getId().equals(inputId)) continue;
            return input2;
        }
        return null;
    }
}

