/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.initializers;

import com.google.common.base.Stopwatch;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.common.util.concurrent.AbstractExecutionThreadService;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.graylog2.plugin.inputs.InputState;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.plugin.lifecycles.Lifecycle;
import org.graylog2.shared.inputs.InputRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class InputSetupService
extends AbstractExecutionThreadService {
    private static final Logger LOG = LoggerFactory.getLogger(InputSetupService.class);
    private final InputRegistry inputRegistry;
    private final EventBus eventBus;
    private final CountDownLatch startLatch = new CountDownLatch(1);
    private final CountDownLatch stopLatch = new CountDownLatch(1);
    private AtomicReference<Lifecycle> previousLifecycle = new AtomicReference<Lifecycle>(Lifecycle.UNINITIALIZED);

    @Inject
    public InputSetupService(InputRegistry inputRegistry, EventBus eventBus) {
        this.inputRegistry = inputRegistry;
        this.eventBus = eventBus;
    }

    @Override
    protected void startUp() throws Exception {
        this.eventBus.register(this);
    }

    @Subscribe
    public void lifecycleChanged(Lifecycle lifecycle) {
        LOG.debug("Lifecycle is now {}", (Object)lifecycle);
        if (lifecycle == Lifecycle.RUNNING && (this.previousLifecycle.get() == Lifecycle.STARTING || this.previousLifecycle.get() == Lifecycle.UNINITIALIZED)) {
            LOG.info("Triggering launching persisted inputs, node transitioned from {} to {}", (Object)this.previousLifecycle.get(), (Object)lifecycle);
            this.previousLifecycle.set(lifecycle);
            this.startLatch.countDown();
        }
        if (lifecycle == Lifecycle.FAILED) {
            this.startLatch.countDown();
        }
    }

    @Override
    protected void run() throws Exception {
        LOG.debug("Delaying lauching persisted inputs until the node is in RUNNING state.");
        Uninterruptibles.awaitUninterruptibly(this.startLatch);
        if (this.previousLifecycle.get() == Lifecycle.RUNNING) {
            LOG.debug("Launching persisted inputs now.");
            this.inputRegistry.launchAllPersisted();
        } else {
            LOG.error("Not starting any inputs because lifecycle is: {}", (Object)this.previousLifecycle.get());
        }
        Uninterruptibles.awaitUninterruptibly(this.stopLatch);
    }

    @Override
    protected void triggerShutdown() {
        this.stopLatch.countDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void shutDown() throws Exception {
        LOG.debug("Stopping InputSetupService");
        this.eventBus.unregister(this);
        for (InputState state : this.inputRegistry.getRunningInputs()) {
            MessageInput input2 = state.getMessageInput();
            LOG.info("Attempting to close input <{}> [{}].", (Object)input2.getUniqueReadableId(), (Object)input2.getName());
            Stopwatch s = Stopwatch.createStarted();
            try {
                input2.stop();
                LOG.info("Input <{}> closed. Took [{}ms]", (Object)input2.getUniqueReadableId(), (Object)s.elapsed(TimeUnit.MILLISECONDS));
            }
            catch (Exception e) {
                LOG.error("Unable to stop input <{}> [{}]: " + e.getMessage(), (Object)input2.getUniqueReadableId(), (Object)input2.getName());
            }
            finally {
                s.stop();
            }
        }
        LOG.debug("Stopped InputSetupService");
    }
}

