/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.initializers;

import com.google.common.collect.Maps;
import com.google.common.util.concurrent.AbstractIdleService;
import com.iterative.groovy.service.GroovyShellService;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.graylog2.plugin.BaseConfiguration;
import org.graylog2.shared.bindings.InstantiationService;

@Singleton
public class GroovyShellSetupService
extends AbstractIdleService {
    private final GroovyShellService groovyShellService = new GroovyShellService();
    private final BaseConfiguration configuration;

    @Inject
    public GroovyShellSetupService(InstantiationService instantiationService, BaseConfiguration configuration) {
        this.configuration = configuration;
        this.groovyShellService.setPort(configuration.getGroovyShellPort());
        HashMap<String, Object> binding = Maps.newHashMap();
        binding.put("instantiationService", instantiationService);
        this.groovyShellService.setBindings(binding);
    }

    @Override
    protected void startUp() throws Exception {
        if (!this.configuration.isGroovyShellEnable()) {
            return;
        }
        this.groovyShellService.start();
    }

    @Override
    protected void shutDown() throws Exception {
        this.groovyShellService.destroy();
    }
}

