/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.bindings;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.AbstractModule;
import com.google.inject.name.Names;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.graylog2.periodical.Periodicals;
import org.graylog2.plugin.Tools;
import org.slf4j.LoggerFactory;

public class SchedulerBindings
extends AbstractModule {
    private static final int SCHEDULED_THREADS_POOL_SIZE = 30;

    @Override
    protected void configure() {
        ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(30, new ThreadFactoryBuilder().setNameFormat("scheduled-%d").setDaemon(false).setUncaughtExceptionHandler(new Tools.LogUncaughtExceptionHandler(LoggerFactory.getLogger("org.graylog2.scheduler.Scheduler"))).build());
        this.bind(ScheduledExecutorService.class).annotatedWith(Names.named("scheduler")).toInstance(scheduler);
        ScheduledExecutorService daemonScheduler = Executors.newScheduledThreadPool(30, new ThreadFactoryBuilder().setNameFormat("scheduled-daemon-%d").setDaemon(true).setUncaughtExceptionHandler(new Tools.LogUncaughtExceptionHandler(LoggerFactory.getLogger("org.graylog2.scheduler.DaemonScheduler"))).build());
        this.bind(ScheduledExecutorService.class).annotatedWith(Names.named("daemonScheduler")).toInstance(daemonScheduler);
        this.bind(Periodicals.class).toInstance(new Periodicals(scheduler, daemonScheduler));
    }
}

