/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.bindings;

import com.codahale.metrics.MetricRegistry;
import com.google.common.eventbus.EventBus;
import com.google.common.util.concurrent.ServiceManager;
import com.google.inject.AbstractModule;
import com.google.inject.Scopes;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import org.graylog2.inputs.gelf.gelf.GELFChunkManager;
import org.graylog2.plugin.inputs.util.ThroughputCounter;
import org.graylog2.plugin.system.NodeId;
import org.graylog2.shared.bindings.InstantiationService;
import org.graylog2.shared.bindings.providers.EventBusProvider;
import org.graylog2.shared.bindings.providers.GELFChunkManagerProvider;
import org.graylog2.shared.bindings.providers.NodeIdProvider;
import org.graylog2.shared.bindings.providers.ProcessBufferProvider;
import org.graylog2.shared.bindings.providers.ServiceManagerProvider;
import org.graylog2.shared.buffers.ProcessBuffer;
import org.graylog2.shared.buffers.ProcessBufferWatermark;
import org.graylog2.shared.stats.ThroughputStats;
import org.jboss.netty.util.HashedWheelTimer;

public class GenericBindings
extends AbstractModule {
    private final InstantiationService instantiationService;

    public GenericBindings(InstantiationService instantiationService) {
        this.instantiationService = instantiationService;
    }

    @Override
    protected void configure() {
        this.bind(MetricRegistry.class).toInstance(new MetricRegistry());
        this.bind(ThroughputStats.class).toInstance(new ThroughputStats());
        this.bind(ProcessBufferWatermark.class).toInstance(new ProcessBufferWatermark());
        this.bind(InstantiationService.class).toInstance(this.instantiationService);
        this.install(new FactoryModuleBuilder().build(ProcessBuffer.Factory.class));
        this.bind(ProcessBuffer.class).toProvider(ProcessBufferProvider.class);
        this.bind(GELFChunkManager.class).toProvider(GELFChunkManagerProvider.class);
        this.bind(NodeId.class).toProvider(NodeIdProvider.class);
        this.bind(ServiceManager.class).toProvider(ServiceManagerProvider.class).asEagerSingleton();
        this.bind(HashedWheelTimer.class).toInstance(new HashedWheelTimer());
        this.bind(ThroughputCounter.class);
        this.bind(EventBus.class).toProvider(EventBusProvider.class).in(Scopes.SINGLETON);
    }
}

