/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.radio.transports.amqp;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.io.IOException;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.RadioMessage;
import org.msgpack.MessagePack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQPSender {
    private static final Logger LOG = LoggerFactory.getLogger(AMQPSender.class);
    private final String hostname;
    private final int port;
    private final String vHost;
    private final String username;
    private final String password;
    private Connection connection;
    private Channel channel;
    private final MessagePack pack = new MessagePack();

    public AMQPSender(String hostname, int port, String vHost, String username, String password) {
        this.hostname = hostname;
        this.port = port;
        this.vHost = vHost;
        this.username = username;
        this.password = password;
    }

    public void send(Message msg) throws IOException {
        if (!this.isConnected()) {
            this.connect();
        }
        byte[] body = RadioMessage.serialize(this.pack, msg);
        boolean mandatory = true;
        this.channel.basicPublish("graylog2", "graylog2-radio-message", mandatory, new AMQP.BasicProperties(), body);
    }

    public void connect() throws IOException {
        ConnectionFactory factory = new ConnectionFactory();
        factory.setHost(this.hostname);
        factory.setPort(this.port);
        factory.setVirtualHost(this.vHost);
        if (this.username != null && !this.username.isEmpty() && this.password != null && !this.password.isEmpty()) {
            factory.setUsername(this.username);
            factory.setPassword(this.password);
        }
        this.connection = factory.newConnection();
        this.channel = this.connection.createChannel();
        this.channel.queueDeclare("graylog2-radio-messages", true, false, false, null);
        this.channel.exchangeDeclare("graylog2", "topic", true, false, null);
        this.channel.queueBind("graylog2-radio-messages", "graylog2", "graylog2-radio-message");
    }

    public boolean isConnected() {
        return this.connection != null && this.connection.isOpen() && this.channel != null && this.channel.isOpen();
    }

    public void close() throws IOException {
        if (this.channel != null && this.channel.isOpen()) {
            this.channel.close();
        }
        if (this.connection != null && this.connection.isOpen()) {
            this.connection.close();
        }
    }
}

