/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.radio.transports.amqp;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.io.IOException;
import javax.inject.Inject;
import org.graylog2.plugin.Message;
import org.graylog2.radio.Configuration;
import org.graylog2.radio.transports.RadioTransport;
import org.graylog2.radio.transports.amqp.AMQPSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQPProducer
implements RadioTransport {
    private static final Logger LOG = LoggerFactory.getLogger(AMQPProducer.class);
    public static final String EXCHANGE = "graylog2";
    public static final String QUEUE = "graylog2-radio-messages";
    public static final String ROUTING_KEY = "graylog2-radio-message";
    private final AMQPSender sender;
    private final MetricRegistry metricRegistry;
    private final Meter incomingMessages;
    private final Meter rejectedMessages;
    private final Timer processTime;

    @Inject
    public AMQPProducer(Configuration configuration, MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
        this.sender = new AMQPSender(configuration.getAmqpHostname(), configuration.getAmqpPort(), configuration.getAmqpVirtualHost(), configuration.getAmqpUsername(), configuration.getAmqpPassword());
        this.incomingMessages = metricRegistry.meter(MetricRegistry.name(AMQPProducer.class, "incomingMessages"));
        this.rejectedMessages = metricRegistry.meter(MetricRegistry.name(AMQPProducer.class, "rejectedMessages"));
        this.processTime = metricRegistry.timer(MetricRegistry.name(AMQPProducer.class, "processTime"));
    }

    @Override
    public void send(Message msg) {
        try (Timer.Context context = this.processTime.time();){
            this.incomingMessages.mark();
            this.sender.send(msg);
        }
        catch (IOException e) {
            LOG.error("Could not write to AMQP.", e);
            this.rejectedMessages.mark();
        }
    }
}

