/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.radio.rest.resources.system.inputs;

import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.configuration.ConfigurationException;
import org.graylog2.plugin.inputs.InputState;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.radio.cluster.InputService;
import org.graylog2.radio.inputs.api.InputSummaryResponse;
import org.graylog2.radio.rest.resources.RestResource;
import org.graylog2.shared.inputs.InputRegistry;
import org.graylog2.shared.inputs.NoSuchInputTypeException;
import org.graylog2.shared.rest.resources.system.inputs.requests.InputLaunchRequest;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/system/inputs")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class InputsResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(InputsResource.class);
    private final InputRegistry inputRegistry;
    private final InputService inputService;

    @Inject
    public InputsResource(InputRegistry inputRegistry, InputService inputService) {
        this.inputRegistry = inputRegistry;
        this.inputService = inputService;
    }

    @GET
    @Timed
    public String list() {
        ArrayList<Map<String, Object>> inputStates = Lists.newArrayList();
        for (InputState inputState : this.inputRegistry.getInputStates()) {
            inputStates.add(inputState.asMap());
        }
        HashMap<String, Serializable> result2 = Maps.newHashMap();
        result2.put("inputs", inputStates);
        result2.put("total", Integer.valueOf(inputStates.size()));
        return this.json(result2);
    }

    @GET
    @Timed
    @Path(value="/{inputId}")
    public String single(@PathParam(value="inputId") String inputId) {
        MessageInput input2 = this.inputRegistry.getRunningInput(inputId);
        if (input2 == null) {
            LOG.info("Input [{}]\u00a0not found. Returning HTTP 404.", (Object)inputId);
            throw new WebApplicationException(404);
        }
        return this.json(input2.asMap());
    }

    @POST
    @Timed
    public Response launch(String body) {
        MessageInput input2;
        InputLaunchRequest lr;
        try {
            lr = this.objectMapper.readValue(body, InputLaunchRequest.class);
        }
        catch (IOException e) {
            LOG.error("Error while parsing JSON", e);
            throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
        }
        Configuration inputConfig = new Configuration(lr.configuration);
        DateTime createdAt = new DateTime(DateTimeZone.UTC);
        try {
            input2 = this.inputRegistry.create(lr.type);
            input2.setTitle(lr.title);
            input2.setCreatorUserId(lr.creatorUserId);
            input2.setCreatedAt(createdAt);
            input2.setGlobal(lr.global);
            input2.checkConfiguration(inputConfig);
        }
        catch (NoSuchInputTypeException e) {
            LOG.error("There is no such input type registered.", e);
            throw new WebApplicationException((Throwable)e, Response.Status.NOT_FOUND);
        }
        catch (ConfigurationException e) {
            LOG.error("Missing or invalid input configuration.", e);
            throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
        }
        String inputId = UUID.randomUUID().toString();
        input2.setPersistId(inputId);
        if (input2.isExclusive() && this.inputRegistry.hasTypeRunning(input2.getClass())) {
            LOG.error("Type is exclusive and already has input running.");
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        input2.initialize(inputConfig);
        this.inputRegistry.launch(input2, inputId, true);
        HashMap<String, String> result2 = Maps.newHashMap();
        result2.put("input_id", inputId);
        result2.put("persist_id", inputId);
        return Response.status(Response.Status.ACCEPTED).entity(this.json(result2)).build();
    }

    @DELETE
    @Timed
    @Path(value="/{inputId}")
    public Response terminate(@PathParam(value="inputId") String inputId) {
        MessageInput input2 = this.inputRegistry.getRunningInput(inputId);
        if (input2 == null) {
            LOG.info("Cannot terminate input. Input not found.");
            throw new WebApplicationException(404);
        }
        String msg = "Attempting to terminate input [" + input2.getName() + "]. Reason: REST request.";
        LOG.info(msg);
        this.inputRegistry.terminate(input2);
        String msg2 = "Terminated input [" + input2.getName() + "]. Reason: REST request.";
        LOG.info(msg2);
        return Response.status(Response.Status.ACCEPTED).build();
    }

    @GET
    @Timed
    @Path(value="/types")
    public String types() {
        HashMap<String, Map<String, String>> result2 = Maps.newHashMap();
        result2.put("types", this.inputRegistry.getAvailableInputs());
        return this.json(result2);
    }

    @GET
    @Timed
    @Path(value="/types/{inputType}")
    public String info(@PathParam(value="inputType") String inputType) {
        MessageInput input2;
        try {
            input2 = this.inputRegistry.create(inputType);
        }
        catch (NoSuchInputTypeException e) {
            LOG.error("There is no such input type registered.", e);
            throw new WebApplicationException((Throwable)e, Response.Status.NOT_FOUND);
        }
        HashMap<String, Object> result2 = Maps.newHashMap();
        result2.put("type", input2.getClass().getCanonicalName());
        result2.put("name", input2.getName());
        result2.put("is_exclusive", input2.isExclusive());
        result2.put("requested_configuration", input2.getRequestedConfiguration().asList());
        result2.put("link_to_docs", input2.linkToDocs());
        return this.json(result2);
    }

    @POST
    @Timed
    @Path(value="/{inputId}/launch")
    public Response launchExisting(@PathParam(value="inputId") String inputId) {
        MessageInput input2;
        InputState inputState = this.inputRegistry.getInputState(inputId);
        if (inputState == null) {
            try {
                InputSummaryResponse response = this.inputService.getPersistedInput(inputId);
                if (response == null) {
                    throw new NotFoundException("Input <" + inputId + "> not found!");
                }
            }
            catch (IOException e) {
                throw new NotFoundException("Input <" + inputId + "> not found!");
            }
        }
        if ((input2 = inputState.getMessageInput()) == null) {
            String error = "Cannot launch input <" + inputId + ">. Input not found.";
            LOG.info(error);
            throw new NotFoundException(error);
        }
        String msg = "Launching existing input [" + input2.getName() + "]. Reason: REST request.";
        LOG.info(msg);
        this.inputRegistry.launch(inputState);
        String msg2 = "Launched existing input [" + input2.getName() + "]. Reason: REST request.";
        LOG.info(msg2);
        HashMap<String, String> result2 = Maps.newHashMap();
        result2.put("input_id", inputId);
        result2.put("persist_id", inputId);
        return Response.status(Response.Status.ACCEPTED).entity(this.json(result2)).build();
    }

    @POST
    @Timed
    @Path(value="/{inputId}/stop")
    public Response stop(@PathParam(value="inputId") String inputId) {
        MessageInput input2 = this.inputRegistry.getRunningInput(inputId);
        if (input2 == null) {
            LOG.info("Cannot stop input. Input not found.");
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        String msg = "Stopping input [" + input2.getName() + "]. Reason: REST request.";
        LOG.info(msg);
        this.inputRegistry.stop(input2);
        String msg2 = "Stopped input [" + input2.getName() + "]. Reason: REST request.";
        LOG.info(msg2);
        return Response.status(Response.Status.ACCEPTED).build();
    }

    @POST
    @Timed
    @Path(value="/{inputId}/restart")
    public Response restart(@PathParam(value="inputId") String inputId) {
        this.stop(inputId);
        this.launchExisting(inputId);
        return Response.status(Response.Status.ACCEPTED).build();
    }
}

