/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.radio.rest.resources.system;

import com.codahale.metrics.annotation.Timed;
import com.codahale.metrics.jvm.ThreadDump;
import com.google.common.collect.Maps;
import java.io.ByteArrayOutputStream;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.plugin.Tools;
import org.graylog2.radio.RadioVersion;
import org.graylog2.radio.rest.resources.RestResource;

@Path(value="/system")
public class SystemResource
extends RestResource {
    @Inject
    private ServerStatus serverStatus;

    @GET
    @Timed
    @Produces(value={"application/json"})
    public String system() {
        HashMap<String, String> result2 = Maps.newHashMap();
        result2.put("facility", "graylog2-radio");
        result2.put("server_id", this.serverStatus.getNodeId().toString());
        result2.put("version", RadioVersion.VERSION.toString());
        result2.put("started_at", Tools.getISO8601String(this.serverStatus.getStartedAt()));
        result2.put("hostname", Tools.getLocalCanonicalHostname());
        result2.put("lifecycle", this.serverStatus.getLifecycle().getDescription().toLowerCase());
        result2.put("lb_status", this.serverStatus.getLifecycle().getLoadbalancerStatus().toString().toLowerCase());
        return this.json(result2);
    }

    @GET
    @Timed
    @Path(value="/jvm")
    @Produces(value={"application/json"})
    public String jvm() {
        Runtime runtime = Runtime.getRuntime();
        HashMap<String, Object> result2 = Maps.newHashMap();
        result2.put("free_memory", this.bytesToValueMap(runtime.freeMemory()));
        result2.put("max_memory", this.bytesToValueMap(runtime.maxMemory()));
        result2.put("total_memory", this.bytesToValueMap(runtime.totalMemory()));
        result2.put("used_memory", this.bytesToValueMap(runtime.totalMemory() - runtime.freeMemory()));
        result2.put("node_id", this.serverStatus.getNodeId().toString());
        result2.put("pid", Tools.getPID());
        result2.put("info", Tools.getSystemInformation());
        return this.json(result2);
    }

    @GET
    @Timed
    @Path(value="/threaddump")
    @Produces(value={"text/plain"})
    public String threaddump() {
        ThreadDump threadDump = new ThreadDump(ManagementFactory.getThreadMXBean());
        ByteArrayOutputStream output2 = new ByteArrayOutputStream();
        threadDump.dump(output2);
        return output2.toString();
    }
}

