/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.radio.rest.resources.system;

import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.graylog2.inputs.InputCache;
import org.graylog2.plugin.buffers.BufferWatermark;
import org.graylog2.radio.Configuration;
import org.graylog2.radio.rest.resources.RestResource;
import org.graylog2.shared.buffers.ProcessBufferWatermark;

@Path(value="/system/buffers")
public class BuffersResource
extends RestResource {
    @Inject
    private Configuration configuration;
    @Inject
    private ProcessBufferWatermark processBufferWatermark;
    @Inject
    private InputCache inputCache;

    @GET
    @Timed
    @Produces(value={"application/json"})
    public String utilization() {
        HashMap<String, Map<String, Object>> result2 = Maps.newHashMap();
        result2.put("buffers", this.buffers());
        result2.put("master_caches", this.masterCaches());
        return this.json(result2);
    }

    private Map<String, Object> masterCaches() {
        HashMap<String, Object> caches = Maps.newHashMap();
        HashMap<String, Integer> input2 = Maps.newHashMap();
        input2.put("size", this.inputCache.size());
        caches.put("input", input2);
        return caches;
    }

    private Map<String, Object> buffers() {
        HashMap<String, Object> buffers = Maps.newHashMap();
        HashMap<String, Number> input2 = Maps.newHashMap();
        BufferWatermark pWm = new BufferWatermark(this.configuration.getRingSize(), this.processBufferWatermark);
        input2.put("utilization_percent", Float.valueOf(pWm.getUtilizationPercentage()));
        input2.put("utilization", pWm.getUtilization());
        buffers.put("input", input2);
        return buffers;
    }
}

