/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.radio.rest.resources;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Timer;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(RestResource.class);
    protected final ObjectMapper objectMapper = new ObjectMapper();
    @QueryParam(value="pretty")
    boolean prettyPrint;

    protected RestResource() {
        this.objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
    }

    protected String json(Object x2) {
        try {
            if (this.prettyPrint) {
                return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(x2);
            }
            return this.objectMapper.writeValueAsString(x2);
        }
        catch (JsonProcessingException e) {
            LOG.error("Error while generating JSON", e);
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    protected Map<String, Long> bytesToValueMap(long bytes) {
        HashMap<String, Long> r = Maps.newHashMap();
        int kb = 1024;
        int mb = kb * 1024;
        r.put("bytes", bytes);
        r.put("kilobytes", bytes / (long)kb);
        r.put("megabytes", bytes / (long)mb);
        return r;
    }

    protected Map<String, Object> buildTimerMap(Timer t) {
        HashMap<String, Object> metrics = Maps.newHashMap();
        if (t == null) {
            return metrics;
        }
        TimeUnit timeUnit = TimeUnit.MICROSECONDS;
        HashMap<String, Long> time = Maps.newHashMap();
        time.put("max", TimeUnit.MICROSECONDS.convert(t.getSnapshot().getMax(), TimeUnit.NANOSECONDS));
        time.put("min", TimeUnit.MICROSECONDS.convert(t.getSnapshot().getMin(), TimeUnit.NANOSECONDS));
        time.put("mean", TimeUnit.MICROSECONDS.convert((long)t.getSnapshot().getMean(), TimeUnit.NANOSECONDS));
        time.put("95th_percentile", TimeUnit.MICROSECONDS.convert((long)t.getSnapshot().get95thPercentile(), TimeUnit.NANOSECONDS));
        time.put("98th_percentile", TimeUnit.MICROSECONDS.convert((long)t.getSnapshot().get98thPercentile(), TimeUnit.NANOSECONDS));
        time.put("99th_percentile", TimeUnit.MICROSECONDS.convert((long)t.getSnapshot().get99thPercentile(), TimeUnit.NANOSECONDS));
        time.put("std_dev", TimeUnit.MICROSECONDS.convert((long)t.getSnapshot().getStdDev(), TimeUnit.NANOSECONDS));
        HashMap<String, Number> rate = Maps.newHashMap();
        rate.put("one_minute", t.getOneMinuteRate());
        rate.put("five_minute", t.getFiveMinuteRate());
        rate.put("fifteen_minute", t.getFifteenMinuteRate());
        rate.put("total", t.getCount());
        rate.put("mean", t.getMeanRate());
        metrics.put("rate_unit", "events/second");
        metrics.put("duration_unit", timeUnit.toString().toLowerCase());
        metrics.put("time", time);
        metrics.put("rate", rate);
        return metrics;
    }

    protected Map<String, Object> buildHistogramMap(Histogram h) {
        HashMap<String, Object> metrics = Maps.newHashMap();
        if (h == null) {
            return metrics;
        }
        HashMap<String, Long> time = Maps.newHashMap();
        time.put("max", h.getSnapshot().getMax());
        time.put("min", h.getSnapshot().getMin());
        time.put("mean", (long)h.getSnapshot().getMean());
        time.put("95th_percentile", (long)h.getSnapshot().get95thPercentile());
        time.put("98th_percentile", (long)h.getSnapshot().get98thPercentile());
        time.put("99th_percentile", (long)h.getSnapshot().get99thPercentile());
        time.put("std_dev", (long)h.getSnapshot().getStdDev());
        metrics.put("time", time);
        metrics.put("count", h.getCount());
        return metrics;
    }

    protected Map<String, Object> buildMeterMap(Meter m) {
        HashMap<String, Object> metrics = Maps.newHashMap();
        if (m == null) {
            return metrics;
        }
        HashMap<String, Number> rate = Maps.newHashMap();
        rate.put("one_minute", m.getOneMinuteRate());
        rate.put("five_minute", m.getFiveMinuteRate());
        rate.put("fifteen_minute", m.getFifteenMinuteRate());
        rate.put("total", m.getCount());
        rate.put("mean", m.getMeanRate());
        metrics.put("rate_unit", "events/second");
        metrics.put("rate", rate);
        return metrics;
    }
}

