/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.radio.inputs;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.ning.http.client.AsyncHttpClient;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.configuration.ConfigurationException;
import org.graylog2.plugin.inputs.InputState;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.radio.cluster.InputService;
import org.graylog2.radio.inputs.api.InputSummaryResponse;
import org.graylog2.radio.inputs.api.RegisterInputResponse;
import org.graylog2.shared.buffers.ProcessBuffer;
import org.graylog2.shared.inputs.InputRegistry;
import org.graylog2.shared.inputs.MessageInputFactory;
import org.graylog2.shared.inputs.NoSuchInputTypeException;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RadioInputRegistry
extends InputRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(RadioInputRegistry.class);
    protected final ObjectMapper mapper = new ObjectMapper();
    protected final AsyncHttpClient httpclient;
    protected final URI serverUrl;
    private final ServerStatus serverStatus;
    private final InputService inputService;

    public RadioInputRegistry(MessageInputFactory messageInputFactory, ProcessBuffer processBuffer, AsyncHttpClient httpclient, URI serverUrl, ServerStatus serverStatus, InputService inputService) {
        super(messageInputFactory, processBuffer);
        this.httpclient = httpclient;
        this.serverUrl = serverUrl;
        this.serverStatus = serverStatus;
        this.inputService = inputService;
    }

    private MessageInput getMessageInput(InputSummaryResponse isr) {
        MessageInput input2;
        try {
            input2 = this.create(isr.type);
            Configuration inputConfig = new Configuration(isr.configuration);
            input2.setTitle(isr.title);
            input2.setCreatorUserId(isr.creatorUserId);
            input2.setPersistId(isr.id);
            input2.setCreatedAt(new DateTime(isr.createdAt));
            input2.setGlobal(isr.global);
            input2.checkConfiguration(inputConfig);
            input2.initialize(inputConfig);
        }
        catch (NoSuchInputTypeException e) {
            LOG.warn("Cannot launch persisted input. No such type [{}]. Error: {}", (Object)isr.type, (Object)e);
            return null;
        }
        catch (ConfigurationException e) {
            LOG.error("Missing or invalid input input configuration.", e);
            return null;
        }
        return input2;
    }

    @Override
    public List<MessageInput> getAllPersisted() {
        List<InputSummaryResponse> response;
        ArrayList<MessageInput> result2 = Lists.newArrayList();
        try {
            response = this.inputService.getPersistedInputs();
        }
        catch (IOException e) {
            LOG.error("Unable to get persisted inputs: ", e);
            return result2;
        }
        for (InputSummaryResponse isr : response) {
            MessageInput messageInput = this.getMessageInput(isr);
            if (messageInput == null) continue;
            LOG.debug("Loaded message input {}", (Object)messageInput);
            result2.add(messageInput);
        }
        return result2;
    }

    @Override
    protected void finishedLaunch(InputState state) {
    }

    @Override
    public void cleanInput(MessageInput input2) {
    }

    @Override
    protected void finishedTermination(InputState state) {
        MessageInput input2 = state.getMessageInput();
        try {
            if (!state.getMessageInput().getGlobal().booleanValue()) {
                this.inputService.unregisterInCluster(input2);
            }
        }
        catch (Exception e) {
            LOG.error("Could not unregister input [{}], id <{}> on server cluster: {}", input2.getName(), input2.getId(), e);
            return;
        }
        LOG.info("Unregistered input [{}], id <{}> on server cluster.", (Object)input2.getName(), (Object)input2.getId());
        this.removeFromRunning(state);
    }

    @Override
    public InputState launch(MessageInput input2, String id, boolean register) {
        if (register) {
            try {
                RegisterInputResponse response = this.inputService.registerInCluster(input2);
                if (response != null) {
                    input2.setPersistId(response.persistId);
                }
            }
            catch (Exception e) {
                LOG.error("Could not register input in Graylog2 cluster. It will be lost on next restart of this radio node.", e);
                return null;
            }
        }
        return super.launch(input2, id, register);
    }

    @Override
    protected void finishedStop(InputState inputState) {
    }
}

