/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.radio.initializers;

import com.google.common.util.concurrent.AbstractIdleService;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.graylog2.inputs.InputCache;
import org.graylog2.radio.Configuration;
import org.graylog2.radio.buffers.processors.RadioProcessBufferProcessor;
import org.graylog2.radio.transports.RadioTransport;
import org.graylog2.shared.buffers.ProcessBuffer;
import org.graylog2.shared.buffers.ProcessBufferWatermark;
import org.graylog2.shared.buffers.processors.ProcessBufferProcessor;

@Singleton
public class RadioProcessBufferService
extends AbstractIdleService {
    private final InputCache inputCache;
    private final RadioProcessBufferProcessor.Factory processBufferProcessorFactory;
    private final Configuration configuration;
    private final ProcessBuffer processBuffer;
    private final RadioTransport transport;
    private final ProcessBufferWatermark processBufferWatermark;

    @Inject
    public RadioProcessBufferService(InputCache inputCache, RadioProcessBufferProcessor.Factory processBufferProcessorFactory, Configuration configuration, ProcessBuffer processBuffer, RadioTransport transport, ProcessBufferWatermark processBufferWatermark) {
        this.inputCache = inputCache;
        this.processBufferProcessorFactory = processBufferProcessorFactory;
        this.configuration = configuration;
        this.processBuffer = processBuffer;
        this.transport = transport;
        this.processBufferWatermark = processBufferWatermark;
    }

    @Override
    protected void startUp() throws Exception {
        int processBufferProcessorCount = this.configuration.getProcessBufferProcessors();
        ProcessBufferProcessor[] processors = new ProcessBufferProcessor[processBufferProcessorCount];
        for (int i = 0; i < processBufferProcessorCount; ++i) {
            processors[i] = this.processBufferProcessorFactory.create(this.processBufferWatermark, i, processBufferProcessorCount, this.transport);
        }
        this.processBuffer.initialize(processors, this.configuration.getRingSize(), this.configuration.getProcessorWaitStrategy(), this.configuration.getProcessBufferProcessors());
    }

    @Override
    protected void shutDown() throws Exception {
    }
}

