/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.radio.cluster;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Response;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.ExecutionException;
import javax.ws.rs.core.UriBuilder;
import org.graylog2.plugin.ServerStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ping {
    private static final Logger LOG = LoggerFactory.getLogger(Ping.class);

    public static void ping(AsyncHttpClient client, URI server, URI ourUri, String radioId) throws IOException, ExecutionException, InterruptedException {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode rootNode = mapper.createObjectNode();
        rootNode.put("rest_transport_address", ourUri.toString());
        UriBuilder uriBuilder = UriBuilder.fromUri(server);
        uriBuilder.path("/system/radios/" + radioId + "/ping");
        ListenableFuture<Response> f2 = client.preparePut(uriBuilder.build(new Object[0]).toString()).setBody(rootNode.toString()).execute();
        Response r = (Response)f2.get();
        if (r.getStatusCode() != 200) {
            throw new RuntimeException("Expected ping HTTP response [200] but got [" + r.getStatusCode() + "].");
        }
    }

    public static class Pinger
    implements Runnable {
        private final AsyncHttpClient httpClient;
        private final String nodeId;
        private final URI serverUri;
        private final URI ourUri;

        @Inject
        public Pinger(AsyncHttpClient httpClient, @Named(value="OurRadioUri") URI ourUri, @Named(value="ServerUri") URI serverUri, ServerStatus serverStatus) {
            this.httpClient = httpClient;
            this.nodeId = serverStatus.getNodeId().toString();
            this.ourUri = ourUri;
            this.serverUri = serverUri;
        }

        @Override
        public void run() {
            this.ping();
        }

        public void ping() {
            LOG.debug("Updating (ping) this radio instance [{}] in the Graylog2 cluster at [{}]", (Object)this.nodeId, (Object)this.serverUri);
            try {
                Ping.ping(this.httpClient, this.serverUri, this.ourUri, this.nodeId);
            }
            catch (Exception e) {
                LOG.error("Cluster ping failed.", e);
            }
        }
    }
}

