/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.radio.buffers.processors;

import com.codahale.metrics.MetricRegistry;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.concurrent.atomic.AtomicInteger;
import org.graylog2.plugin.Message;
import org.graylog2.radio.transports.RadioTransport;
import org.graylog2.shared.buffers.processors.ProcessBufferProcessor;
import org.graylog2.shared.stats.ThroughputStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RadioProcessBufferProcessor
extends ProcessBufferProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(RadioProcessBufferProcessor.class);
    private final ThroughputStats throughputStats;
    private final RadioTransport radioTransport;

    @AssistedInject
    public RadioProcessBufferProcessor(MetricRegistry metricRegistry, ThroughputStats throughputStats, @Assisted AtomicInteger processBufferWatermark, @Assisted(value="ordinal") long ordinal, @Assisted(value="numberOfConsumers") long numberOfConsumers, @Assisted RadioTransport radioTransport) {
        super(metricRegistry, processBufferWatermark, ordinal, numberOfConsumers);
        this.throughputStats = throughputStats;
        this.radioTransport = radioTransport;
    }

    @Override
    protected void handleMessage(Message msg) {
        this.radioTransport.send(msg);
        this.throughputStats.getThroughputCounter().add(1L);
        LOG.debug("Message <{}> written to RadioTransport.", (Object)msg.getId());
    }

    public static interface Factory {
        public RadioProcessBufferProcessor create(AtomicInteger var1, @Assisted(value="ordinal") long var2, @Assisted(value="numberOfConsumers") long var4, RadioTransport var6);
    }
}

