/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.radio.bindings;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.AbstractModule;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Names;
import com.google.inject.util.Providers;
import com.ning.http.client.AsyncHttpClient;
import java.net.URI;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.ext.ExceptionMapper;
import org.graylog2.inputs.BasicCache;
import org.graylog2.inputs.InputCache;
import org.graylog2.jersey.container.netty.SecurityContextFactory;
import org.graylog2.plugin.BaseConfiguration;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.radio.Configuration;
import org.graylog2.radio.bindings.providers.AsyncHttpClientProvider;
import org.graylog2.radio.bindings.providers.RadioInputRegistryProvider;
import org.graylog2.radio.buffers.processors.RadioProcessBufferProcessor;
import org.graylog2.radio.transports.RadioTransport;
import org.graylog2.radio.transports.amqp.AMQPProducer;
import org.graylog2.radio.transports.kafka.KafkaProducer;
import org.graylog2.shared.bindings.providers.ObjectMapperProvider;
import org.graylog2.shared.inputs.InputRegistry;

public class RadioBindings
extends AbstractModule {
    private final Configuration configuration;

    public RadioBindings(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    protected void configure() {
        this.bindProviders();
        this.bindSingletons();
        this.bindTransport();
        this.install(new FactoryModuleBuilder().build(RadioProcessBufferProcessor.Factory.class));
        Object instance = null;
        this.bind(SecurityContextFactory.class).toProvider(Providers.of(instance));
        this.bindDynamicFeatures();
        this.bindContainerResponseFilters();
        this.bindExceptionMappers();
    }

    private void bindSingletons() {
        this.bind(Configuration.class).toInstance(this.configuration);
        this.bind(BaseConfiguration.class).toInstance(this.configuration);
        Multibinder<ServerStatus.Capability> capabilityBinder = Multibinder.newSetBinder(this.binder(), ServerStatus.Capability.class);
        capabilityBinder.addBinding().toInstance(ServerStatus.Capability.RADIO);
        this.bind(ServerStatus.class).in(Scopes.SINGLETON);
        this.bind(InputRegistry.class).toProvider(RadioInputRegistryProvider.class).asEagerSingleton();
        this.bind(URI.class).annotatedWith(Names.named("ServerUri")).toInstance(this.configuration.getGraylog2ServerUri());
        this.bind(URI.class).annotatedWith(Names.named("OurRadioUri")).toInstance(this.configuration.getRestTransportUri());
        this.bind(InputCache.class).to(BasicCache.class).in(Scopes.SINGLETON);
    }

    private void bindProviders() {
        this.bind(AsyncHttpClient.class).toProvider(AsyncHttpClientProvider.class);
        this.bind(ObjectMapper.class).toProvider(ObjectMapperProvider.class);
    }

    private void bindTransport() {
        switch (this.configuration.getTransportType()) {
            case AMQP: {
                this.bind(RadioTransport.class).to(AMQPProducer.class);
                break;
            }
            case KAFKA: {
                this.bind(RadioTransport.class).to(KafkaProducer.class);
                break;
            }
            default: {
                throw new RuntimeException("Cannot map transport type to transport.");
            }
        }
    }

    private void bindDynamicFeatures() {
        TypeLiteral<Class<? extends DynamicFeature>> type = new TypeLiteral<Class<? extends DynamicFeature>>(){};
        Multibinder<Class<? extends DynamicFeature>> setBinder = Multibinder.newSetBinder(this.binder(), type);
    }

    private void bindContainerResponseFilters() {
        TypeLiteral<Class<? extends ContainerResponseFilter>> type = new TypeLiteral<Class<? extends ContainerResponseFilter>>(){};
        Multibinder<Class<? extends ContainerResponseFilter>> setBinder = Multibinder.newSetBinder(this.binder(), type);
    }

    private void bindExceptionMappers() {
        TypeLiteral<Class<? extends ExceptionMapper>> type = new TypeLiteral<Class<? extends ExceptionMapper>>(){};
        Multibinder<Class<? extends ExceptionMapper>> setBinder = Multibinder.newSetBinder(this.binder(), type);
    }
}

