/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.radio;

import com.beust.jcommander.JCommander;
import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.log4j.InstrumentedAppender;
import com.github.joschi.jadconfig.JadConfig;
import com.github.joschi.jadconfig.ParameterException;
import com.github.joschi.jadconfig.RepositoryException;
import com.github.joschi.jadconfig.ValidationException;
import com.github.joschi.jadconfig.repositories.EnvironmentRepository;
import com.github.joschi.jadconfig.repositories.PropertiesRepository;
import com.github.joschi.jadconfig.repositories.SystemPropertiesRepository;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ServiceManager;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Level;
import org.graylog2.plugin.Plugin;
import org.graylog2.plugin.PluginModule;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.plugin.Tools;
import org.graylog2.radio.CommandLineArguments;
import org.graylog2.radio.Configuration;
import org.graylog2.radio.RadioVersion;
import org.graylog2.radio.bindings.RadioBindings;
import org.graylog2.radio.bindings.RadioInitializerBindings;
import org.graylog2.radio.cluster.Ping;
import org.graylog2.shared.NodeRunner;
import org.graylog2.shared.bindings.GuiceInjectorHolder;
import org.graylog2.shared.bindings.GuiceInstantiationService;
import org.graylog2.shared.initializers.ServiceManagerListener;
import org.graylog2.shared.plugins.PluginLoader;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class Main
extends NodeRunner {
    private static final Logger LOG = LoggerFactory.getLogger(Main.class);
    private static final String ENVIRONMENT_PREFIX = "GRAYLOG2_";
    private static final String PROPERTIES_PREFIX = "graylog2.";

    public static void main(String[] args) {
        JadConfig jadConfig;
        CommandLineArguments commandLineArguments = new CommandLineArguments();
        JCommander jCommander = new JCommander((Object)commandLineArguments, args);
        jCommander.setProgramName("graylog2-radio");
        if (commandLineArguments.isShowHelp()) {
            jCommander.usage();
            System.exit(0);
        }
        if (commandLineArguments.isShowVersion()) {
            System.out.println("Graylog2 Radio " + RadioVersion.VERSION);
            System.out.println("JRE: " + Tools.getSystemInformation());
            System.exit(0);
        }
        if (commandLineArguments.isDumpDefaultConfig()) {
            jadConfig = new JadConfig();
            jadConfig.addConfigurationBean(new Configuration());
            System.out.println(Main.dumpConfiguration(jadConfig.dump()));
            System.exit(0);
        }
        jadConfig = new JadConfig();
        Configuration configuration = Main.readConfiguration(jadConfig, commandLineArguments.getConfigFile());
        if (commandLineArguments.isDumpConfig()) {
            System.out.println(Main.dumpConfiguration(jadConfig.dump()));
            System.exit(0);
        }
        Level logLevel = Level.INFO;
        if (commandLineArguments.isDebug()) {
            LOG.info("Running in Debug mode");
            logLevel = Level.DEBUG;
        }
        PluginLoader pluginLoader = new PluginLoader(new File(configuration.getPluginDir()));
        ArrayList<PluginModule> pluginModules = Lists.newArrayList();
        for (Plugin plugin : pluginLoader.loadPlugins()) {
            pluginModules.addAll(plugin.modules());
        }
        LOG.debug("Loaded modules: " + pluginModules);
        GuiceInstantiationService instantiationService = new GuiceInstantiationService();
        List<Module> bindingsModules = Main.getBindingsModules(instantiationService, new RadioBindings(configuration), new RadioInitializerBindings());
        LOG.debug("Adding plugin modules: " + pluginModules);
        bindingsModules.addAll(pluginModules);
        Injector injector = GuiceInjectorHolder.createInjector(bindingsModules);
        instantiationService.setInjector(injector);
        MetricRegistry metrics = injector.getInstance(MetricRegistry.class);
        JmxReporter reporter = JmxReporter.forRegistry(metrics).build();
        reporter.start();
        InstrumentedAppender logMetrics = new InstrumentedAppender(metrics);
        logMetrics.activateOptions();
        org.apache.log4j.Logger.getRootLogger().setLevel(logLevel);
        org.apache.log4j.Logger.getLogger(Main.class.getPackage().getName()).setLevel(logLevel);
        org.apache.log4j.Logger.getRootLogger().addAppender(logMetrics);
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
        LOG.info("Graylog2 Radio {} starting up. (JRE: {})", (Object)RadioVersion.VERSION, (Object)Tools.getSystemInformation());
        if (!commandLineArguments.isNoPidFile()) {
            Main.savePidFile(commandLineArguments.getPidFile());
        }
        ServerStatus serverStatus = injector.getInstance(ServerStatus.class);
        serverStatus.initialize();
        Ping.Pinger pinger = injector.getInstance(Ping.Pinger.class);
        pinger.ping();
        ServiceManager serviceManager = injector.getInstance(ServiceManager.class);
        ServiceManagerListener serviceManagerListener = injector.getInstance(ServiceManagerListener.class);
        serviceManager.addListener(serviceManagerListener, MoreExecutors.sameThreadExecutor());
        serviceManager.startAsync().awaitHealthy();
        LOG.info("Graylog2 Radio up and running.");
        while (true) {
            try {
                while (true) {
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException e) {
                continue;
            }
            break;
        }
    }

    private static Configuration readConfiguration(JadConfig jadConfig, String configFile) {
        Configuration configuration = new Configuration();
        jadConfig.addConfigurationBean(configuration);
        jadConfig.setRepositories(Arrays.asList(new EnvironmentRepository(ENVIRONMENT_PREFIX), new SystemPropertiesRepository(PROPERTIES_PREFIX), new PropertiesRepository(configFile)));
        LOG.debug("Loading configuration from config file: {}", (Object)configFile);
        try {
            jadConfig.process();
        }
        catch (RepositoryException e) {
            LOG.error("Couldn't load configuration: {}", (Object)e.getMessage());
            System.exit(1);
        }
        catch (ParameterException | ValidationException e) {
            LOG.error("Invalid configuration", e);
            System.exit(1);
        }
        if (configuration.getRestTransportUri() == null) {
            configuration.setRestTransportUri(configuration.getDefaultRestTransportUri().toString());
            LOG.info("No rest_transport_uri set. Falling back to [{}].", (Object)configuration.getRestTransportUri());
        }
        return configuration;
    }

    private static String dumpConfiguration(Map<String, String> configMap) {
        StringBuilder sb = new StringBuilder();
        sb.append("# Configuration of graylog2-radio ").append(RadioVersion.VERSION).append(System.lineSeparator());
        sb.append("# Generated on ").append(DateTime.now()).append(System.lineSeparator());
        for (Map.Entry<String, String> entry2 : configMap.entrySet()) {
            sb.append(entry2.getKey()).append('=').append(Strings.nullToEmpty(entry2.getValue())).append(System.lineSeparator());
        }
        return sb.toString();
    }
}

