/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.radio;

import com.github.joschi.jadconfig.Parameter;
import com.github.joschi.jadconfig.validators.InetPortValidator;
import com.github.joschi.jadconfig.validators.PositiveIntegerValidator;
import java.net.URI;
import org.graylog2.plugin.BaseConfiguration;
import org.graylog2.plugin.Tools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration
extends BaseConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(Configuration.class);
    @Parameter(value="node_id_file")
    private String nodeIdFile = "/etc/graylog2-radio-node-id";
    @Parameter(value="transport_type", required=true)
    private String transportType = "amqp";
    @Parameter(value="rest_listen_uri", required=true)
    private String restListenUri = "http://127.0.0.1:12950/";
    @Parameter(value="graylog2_server_uri", required=true)
    private String graylog2ServerUri;
    @Parameter(value="rest_transport_uri")
    private String restTransportUri;
    @Parameter(value="kafka_brokers")
    private String kafkaBrokers;
    @Parameter(value="kafka_required_acks")
    private int kafkaRequiredAcks = 1;
    @Parameter(value="kafka_producer_type")
    private String kafkaProducerType = "async";
    @Parameter(value="kafka_batch_size", validator=PositiveIntegerValidator.class)
    private int kafkaBatchSize = 200;
    @Parameter(value="kafka_batch_max_wait_ms", validator=PositiveIntegerValidator.class)
    private int kafkaBatchMaxWaitMs = 250;
    @Parameter(value="amqp_broker_hostname")
    private String amqpHostname = "localhost";
    @Parameter(value="amqp_broker_port", validator=InetPortValidator.class)
    private int amqpPort = 5672;
    @Parameter(value="amqp_broker_username")
    private String amqpUsername;
    @Parameter(value="amqp_broker_password")
    private String amqpPassword;
    @Parameter(value="amqp_broker_vhost")
    private String amqpVhost = "/";
    @Parameter(value="ring_size", required=true, validator=PositiveIntegerValidator.class)
    private int ringSize = 1024;

    @Override
    public String getNodeIdFile() {
        return this.nodeIdFile;
    }

    public TRANSPORT_TYPE getTransportType() {
        try {
            return TRANSPORT_TYPE.valueOf(this.transportType.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Invalid [transport_type] configured: " + this.transportType);
        }
    }

    @Override
    public URI getRestListenUri() {
        return Tools.getUriStandard(this.restListenUri);
    }

    public URI getGraylog2ServerUri() {
        if (this.graylog2ServerUri == null || this.graylog2ServerUri.isEmpty()) {
            return null;
        }
        return Tools.getUriStandard(this.graylog2ServerUri);
    }

    public int getRingSize() {
        return this.ringSize;
    }

    public String getKafkaBrokers() {
        return this.kafkaBrokers;
    }

    public int getKafkaRequiredAcks() {
        return this.kafkaRequiredAcks;
    }

    public String getKafkaProducerType() {
        return this.kafkaProducerType;
    }

    public int getKafkaBatchSize() {
        return this.kafkaBatchSize;
    }

    public int getKafkaBatchMaxWaitMs() {
        return this.kafkaBatchMaxWaitMs;
    }

    public String getAmqpPassword() {
        return this.amqpPassword;
    }

    public String getAmqpUsername() {
        return this.amqpUsername;
    }

    public String getAmqpVirtualHost() {
        return this.amqpVhost;
    }

    public int getAmqpPort() {
        return this.amqpPort;
    }

    public String getAmqpHostname() {
        return this.amqpHostname;
    }

    public static enum TRANSPORT_TYPE {
        AMQP,
        KAFKA;

    }
}

