/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin.system;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.graylog2.plugin.Tools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeId {
    private static final Logger LOG = LoggerFactory.getLogger(NodeId.class);
    private final String filename;
    private final String id;

    public NodeId(String filename) {
        this.filename = filename;
        this.id = this.readOrGenerate();
    }

    private String readOrGenerate() {
        try {
            String read2 = this.read();
            if (read2 == null || read2.isEmpty()) {
                return this.generate();
            }
            LOG.info("Node ID: {}", (Object)read2);
            return read2;
        }
        catch (FileNotFoundException e) {
            return this.generate();
        }
        catch (Exception e2) {
            LOG.error("Could not read or generate node ID: ", e2);
            throw new RuntimeException(e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String read() throws IOException {
        try (BufferedReader br = new BufferedReader(new FileReader(this.filename));){
            String string2 = br.readLine();
            return string2;
        }
    }

    private String generate() {
        String generated = Tools.generateServerId();
        LOG.info("No node ID file found. Generated: {}", (Object)generated);
        try {
            this.persist(generated);
        }
        catch (IOException e1) {
            LOG.error("Could not persist node ID: ", e1);
            throw new RuntimeException(e1);
        }
        return generated;
    }

    private void persist(String nodeId) throws IOException {
        FileUtils.writeStringToFile(new File(this.filename), nodeId);
    }

    public String toString() {
        return this.id;
    }
}

