/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin.rest;

import com.fasterxml.jackson.databind.exc.PropertyBindingException;
import com.google.common.base.Joiner;
import java.util.Collection;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.glassfish.jersey.spi.ExtendedExceptionMapper;

@Provider
public class JacksonPropertyExceptionMapper
implements ExtendedExceptionMapper<PropertyBindingException> {
    @Override
    public boolean isMappable(PropertyBindingException exception) {
        return exception != null;
    }

    @Override
    public Response toResponse(PropertyBindingException exception) {
        Collection<Object> knownPropertyIds = exception.getKnownPropertyIds();
        StringBuilder b = new StringBuilder();
        b.append("Unable to map property ").append(exception.getPropertyName()).append(". \n");
        b.append("Known properties include: ").append(Joiner.on(", ").join(knownPropertyIds));
        String message = b.toString();
        return Response.status(Response.Status.BAD_REQUEST).entity(message).build();
    }
}

