/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin.inputs.util;

import com.codahale.metrics.Gauge;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.jboss.netty.handler.traffic.GlobalTrafficShapingHandler;
import org.jboss.netty.handler.traffic.TrafficCounter;
import org.jboss.netty.util.HashedWheelTimer;

public class ThroughputCounter
extends GlobalTrafficShapingHandler {
    @Inject
    public ThroughputCounter(HashedWheelTimer wheelTimer) {
        super(wheelTimer, 1000L);
    }

    public Map<String, Gauge<Long>> gauges() {
        HashMap<String, Gauge<Long>> gauges = Maps.newHashMap();
        final TrafficCounter tc = this.getTrafficCounter();
        gauges.put("read_bytes_1sec", new Gauge<Long>(){

            @Override
            public Long getValue() {
                return tc.getLastReadBytes();
            }
        });
        gauges.put("written_bytes_1sec", new Gauge<Long>(){

            @Override
            public Long getValue() {
                return tc.getLastWrittenBytes();
            }
        });
        gauges.put("read_bytes_total", new Gauge<Long>(){

            @Override
            public Long getValue() {
                return tc.getCumulativeReadBytes();
            }
        });
        gauges.put("written_bytes_total", new Gauge<Long>(){

            @Override
            public Long getValue() {
                return tc.getCumulativeWrittenBytes();
            }
        });
        return gauges;
    }
}

