/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin.inputs;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.buffers.Buffer;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.configuration.ConfigurationException;
import org.graylog2.plugin.configuration.ConfigurationRequest;
import org.graylog2.plugin.configuration.fields.TextField;
import org.graylog2.plugin.inputs.Extractor;
import org.graylog2.plugin.inputs.MisfireException;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MessageInput {
    private static final Logger LOG = LoggerFactory.getLogger(MessageInput.class);
    public static final String CK_RECV_BUFFER_SIZE = "recv_buffer_size";
    private static long defaultRecvBufferSize = 0x100000L;
    protected String title;
    protected String creatorUserId;
    protected String persistId;
    protected DateTime createdAt;
    protected Boolean global = false;
    protected Configuration configuration;
    private Map<String, Extractor> extractors = Maps.newHashMap();
    private Map<String, String> staticFields = Maps.newConcurrentMap();

    public void initialize(Configuration configuration) {
        this.configuration = configuration;
    }

    public abstract void checkConfiguration(Configuration var1) throws ConfigurationException;

    public void checkConfiguration() throws ConfigurationException {
        this.checkConfiguration(this.getConfiguration());
    }

    public abstract void launch(Buffer var1) throws MisfireException;

    public abstract void stop();

    public abstract ConfigurationRequest getRequestedConfiguration();

    public abstract boolean isExclusive();

    public abstract String getName();

    public abstract String linkToDocs();

    public abstract Map<String, Object> getAttributes();

    public void setPersistId(String id) {
        this.persistId = id;
    }

    public String getId() {
        return this.persistId;
    }

    public String getPersistId() {
        return this.persistId;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getCreatorUserId() {
        return this.creatorUserId;
    }

    public void setCreatorUserId(String creatorUserId) {
        this.creatorUserId = creatorUserId;
    }

    public void setCreatedAt(DateTime createdAt) {
        this.createdAt = createdAt;
    }

    public DateTime getCreatedAt() {
        return this.createdAt;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Boolean getGlobal() {
        return this.global;
    }

    public void setGlobal(Boolean global) {
        this.global = global;
    }

    public Object getAttributesWithMaskedPasswords() {
        HashMap<String, Object> result2 = Maps.newHashMap();
        ConfigurationRequest config = this.getRequestedConfiguration();
        if (config == null) {
            return result2;
        }
        for (Map.Entry<String, Object> attribute : this.getAttributes().entrySet()) {
            String attributeKey;
            Object value2 = attribute.getValue();
            Map<String, Map<String, Object>> configAsList = config.asList();
            Map<String, Object> attributesForConfigSetting = configAsList.get(attributeKey = attribute.getKey());
            if (attributesForConfigSetting != null) {
                List attributes = (List)attributesForConfigSetting.get("attributes");
                if (attributes.contains(TextField.Attribute.IS_PASSWORD.toString().toLowerCase())) {
                    value2 = "********";
                }
            } else {
                LOG.warn("Unknown input configuration setting {}={} found. Not trying to mask its value, though this is likely a bug.", (Object)attribute, value2);
            }
            result2.put(attributeKey, value2);
        }
        return result2;
    }

    public Map<String, Object> asMap() {
        HashMap<String, Object> inputMap = Maps.newHashMap();
        inputMap.put("type", this.getClass().getCanonicalName());
        inputMap.put("input_id", this.getId());
        inputMap.put("persist_id", this.getPersistId());
        inputMap.put("name", this.getName());
        inputMap.put("title", this.getTitle());
        inputMap.put("creator_user_id", this.getCreatorUserId());
        inputMap.put("started_at", Tools.getISO8601String(this.getCreatedAt()));
        inputMap.put("attributes", this.getAttributesWithMaskedPasswords());
        inputMap.put("static_fields", this.getStaticFields());
        inputMap.put("global", this.getGlobal());
        return inputMap;
    }

    public synchronized void addExtractor(String id, Extractor extractor) {
        this.extractors.put(id, extractor);
    }

    public Map<String, Extractor> getExtractors() {
        return this.extractors;
    }

    public void addStaticField(String key, String value2) {
        this.staticFields.put(key, value2);
    }

    public Map<String, String> getStaticFields() {
        return this.staticFields;
    }

    public String getUniqueReadableId() {
        String readableId = this.getClass().getName() + "." + this.getId();
        return readableId;
    }

    public int hashCode() {
        return this.getPersistId().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof MessageInput) {
            MessageInput input2 = (MessageInput)obj;
            return this.getPersistId().equals(input2.getPersistId());
        }
        return false;
    }

    public static void setDefaultRecvBufferSize(long size2) {
        defaultRecvBufferSize = size2;
    }

    public long getRecvBufferSize() {
        if (this.configuration.intIsSet(CK_RECV_BUFFER_SIZE)) {
            return this.configuration.getInt(CK_RECV_BUFFER_SIZE);
        }
        return defaultRecvBufferSize;
    }
}

