/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin.inputs;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.inputs.MessageInput;
import org.joda.time.DateTime;

public class InputState {
    protected MessageInput messageInput;
    protected final String id;
    protected InputStateType state;
    protected DateTime startedAt;
    protected String detailedMessage;

    public InputState(MessageInput input2) {
        this(input2, InputStateType.CREATED);
    }

    public InputState(MessageInput input2, InputStateType state) {
        this(input2, state, UUID.randomUUID().toString());
    }

    public InputState(MessageInput input2, String id) {
        this(input2, InputStateType.CREATED, id);
    }

    public InputState(MessageInput input2, InputStateType state, String id) {
        this.state = state;
        this.messageInput = input2;
        this.id = id;
        this.startedAt = DateTime.now();
    }

    public MessageInput getMessageInput() {
        return this.messageInput;
    }

    public void setMessageInput(MessageInput messageInput) {
        this.messageInput = messageInput;
    }

    public String getId() {
        return this.id;
    }

    public InputStateType getState() {
        return this.state;
    }

    public void setState(InputStateType state) {
        this.state = state;
        this.setDetailedMessage(null);
    }

    public DateTime getStartedAt() {
        return this.startedAt;
    }

    public void setStartedAt(DateTime startedAt) {
        this.startedAt = startedAt;
    }

    public String getDetailedMessage() {
        return this.detailedMessage;
    }

    public void setDetailedMessage(String detailedMessage) {
        this.detailedMessage = detailedMessage;
    }

    public Map<String, Object> asMap() {
        HashMap<String, Object> inputStateMap = Maps.newHashMap();
        inputStateMap.put("id", this.id);
        inputStateMap.put("state", this.state.toString().toLowerCase());
        inputStateMap.put("started_at", Tools.getISO8601String(this.startedAt));
        inputStateMap.put("message_input", this.messageInput.asMap());
        inputStateMap.put("detailed_message", this.detailedMessage);
        return inputStateMap;
    }

    public String toString() {
        return "InputState{messageInput=" + this.messageInput + ", id='" + this.id + '\'' + ", state=" + (Object)((Object)this.state) + ", startedAt=" + this.startedAt + ", detailedMessage='" + this.detailedMessage + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InputState that = (InputState)o;
        if (!this.id.equals(that.id)) {
            return false;
        }
        return this.messageInput.equals(that.messageInput);
    }

    public int hashCode() {
        int result2 = this.messageInput.hashCode();
        result2 = 31 * result2 + this.id.hashCode();
        return result2;
    }

    public static enum InputStateType {
        CREATED,
        INITIALIZED,
        INVALID_CONFIGURATION,
        STARTING,
        RUNNING,
        FAILED,
        STOPPED,
        TERMINATED;

    }
}

