/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin.inputs;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.database.EmbeddedPersistable;
import org.graylog2.plugin.inputs.Converter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Extractor
implements EmbeddedPersistable {
    private static final Logger LOG = LoggerFactory.getLogger(Extractor.class);
    protected final AtomicLong exceptions;
    protected final AtomicLong converterExceptions;
    protected final String id;
    protected final String title;
    protected final Type superType;
    protected final CursorStrategy cursorStrategy;
    protected final String targetField;
    protected final String sourceField;
    protected final String creatorUserId;
    protected final Map<String, Object> extractorConfig;
    protected final List<Converter> converters;
    protected final ConditionType conditionType;
    protected final String conditionValue;
    protected long order;
    protected Pattern regexConditionPattern;
    private final String totalTimerName;
    private final String converterTimerName;
    protected final MetricRegistry metricRegistry;

    protected abstract Result run(String var1);

    public Extractor(MetricRegistry metricRegistry, String id, String title, int order, Type type, CursorStrategy cursorStrategy, String sourceField, String targetField, Map<String, Object> extractorConfig, String creatorUserId, List<Converter> converters, ConditionType conditionType, String conditionValue) throws ReservedFieldException {
        this.metricRegistry = metricRegistry;
        if (Message.RESERVED_FIELDS.contains(targetField) && !Message.RESERVED_SETTABLE_FIELDS.contains(targetField)) {
            throw new ReservedFieldException("You cannot apply an extractor on reserved field [" + targetField + "].");
        }
        this.exceptions = new AtomicLong(0L);
        this.converterExceptions = new AtomicLong(0L);
        this.id = id;
        this.title = title;
        this.order = order;
        this.superType = type;
        this.cursorStrategy = cursorStrategy;
        this.targetField = targetField;
        this.sourceField = sourceField;
        this.extractorConfig = extractorConfig;
        this.creatorUserId = creatorUserId;
        this.converters = converters;
        this.conditionType = conditionType;
        this.conditionValue = conditionValue;
        if (conditionType.equals((Object)ConditionType.REGEX)) {
            this.regexConditionPattern = Pattern.compile(conditionValue, 32);
        }
        this.totalTimerName = MetricRegistry.name(this.getClass(), this.getType().toString().toLowerCase(), this.getId(), "executionTime");
        this.converterTimerName = MetricRegistry.name(this.getClass(), this.getType().toString().toLowerCase(), this.getId(), "converterExecutionTime");
    }

    public void runExtractor(Message msg) {
        if (!(msg.getField(this.sourceField) instanceof String)) {
            return;
        }
        String field2 = (String)msg.getField(this.sourceField);
        if (this.conditionType.equals((Object)ConditionType.STRING) ? !field2.contains(this.conditionValue) : this.conditionType.equals((Object)ConditionType.REGEX) && !this.regexConditionPattern.matcher(field2).find()) {
            return;
        }
        Timer timer = this.metricRegistry.timer(this.getTotalTimerName());
        Timer.Context timerContext = timer.time();
        Result result2 = this.run(field2);
        if (result2 == null || result2.getValue() == null) {
            timerContext.close();
            return;
        }
        msg.addField(this.targetField, result2.getValue());
        if (this.cursorStrategy.equals((Object)CursorStrategy.CUT) && !this.targetField.equals(this.sourceField) && !Message.RESERVED_FIELDS.contains(this.sourceField)) {
            StringBuilder sb = new StringBuilder(field2);
            sb.delete(result2.getBeginIndex(), result2.getEndIndex());
            String finalResult = sb.toString();
            if (finalResult.isEmpty()) {
                finalResult = "fullyCutByExtractor";
            }
            msg.removeField(this.sourceField);
            msg.addField(this.sourceField, finalResult);
        }
        this.runConverters(msg);
        timerContext.stop();
    }

    public void runConverters(Message msg) {
        Timer cTimer = this.metricRegistry.timer(this.getConverterTimerName());
        Timer.Context cTimerContext = cTimer.time();
        for (Converter converter : this.converters) {
            try {
                if (!(msg.getFields().get(this.targetField) instanceof String)) continue;
                if (!converter.buildsMultipleFields()) {
                    Object converted = converter.convert((String)msg.getFields().get(this.targetField));
                    msg.removeField(this.targetField);
                    msg.addField(this.targetField, converted);
                    continue;
                }
                Map convert = (Map)converter.convert((String)msg.getFields().get(this.targetField));
                for (String reservedField : Message.RESERVED_FIELDS) {
                    if (!convert.containsKey(reservedField)) continue;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Not setting reserved field {} from converter {} on message {}, rest of the message is being processed", reservedField, converter.getType(), msg.getId());
                    }
                    this.converterExceptions.incrementAndGet();
                    convert.remove(reservedField);
                }
                msg.addFields(convert);
            }
            catch (Exception e) {
                this.converterExceptions.incrementAndGet();
                LOG.error("Could not apply converter [" + converter.getType() + "] of extractor [" + this.getId() + "].", e);
            }
        }
        cTimerContext.stop();
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public Long getOrder() {
        return this.order;
    }

    public void setOrder(long order) {
        this.order = order;
    }

    public Type getType() {
        return this.superType;
    }

    public CursorStrategy getCursorStrategy() {
        return this.cursorStrategy;
    }

    public String getTargetField() {
        return this.targetField;
    }

    public String getSourceField() {
        return this.sourceField;
    }

    public Map<String, Object> getExtractorConfig() {
        return this.extractorConfig;
    }

    public String getCreatorUserId() {
        return this.creatorUserId;
    }

    public String getConditionValue() {
        return this.conditionValue;
    }

    public ConditionType getConditionType() {
        return this.conditionType;
    }

    @Override
    public Map<String, Object> getPersistedFields() {
        return new HashMap<String, Object>(){
            {
                this.put("id", Extractor.this.id);
                this.put("title", Extractor.this.title);
                this.put("order", Extractor.this.order);
                this.put("type", Extractor.this.superType.toString().toLowerCase());
                this.put("cursor_strategy", Extractor.this.cursorStrategy.toString().toLowerCase());
                this.put("target_field", Extractor.this.targetField);
                this.put("source_field", Extractor.this.sourceField);
                this.put("creator_user_id", Extractor.this.creatorUserId);
                this.put("extractor_config", Extractor.this.extractorConfig);
                this.put("condition_type", Extractor.this.conditionType.toString().toLowerCase());
                this.put("condition_value", Extractor.this.conditionValue);
                this.put("converters", Extractor.this.converterConfigMap());
            }
        };
    }

    public List<Map<String, Object>> converterConfigMap() {
        ArrayList<Map<String, Object>> converterConfig = Lists.newArrayList();
        for (Converter converter : this.converters) {
            HashMap<String, Object> config = Maps.newHashMap();
            config.put("type", converter.getType().toLowerCase());
            config.put("config", converter.getConfig());
            converterConfig.add(config);
        }
        return converterConfig;
    }

    public String getTotalTimerName() {
        return this.totalTimerName;
    }

    public String getConverterTimerName() {
        return this.converterTimerName;
    }

    public long getExceptionCount() {
        return this.exceptions.get();
    }

    public long getConverterExceptionCount() {
        return this.converterExceptions.get();
    }

    public void incrementExceptions() {
        this.exceptions.incrementAndGet();
    }

    public class Result {
        private final String value;
        private final int beginIndex;
        private final int endIndex;

        public Result(String value2, int beginIndex, int endIndex) {
            this.value = value2;
            this.beginIndex = beginIndex;
            this.endIndex = endIndex;
        }

        public String getValue() {
            return this.value;
        }

        public int getBeginIndex() {
            return this.beginIndex;
        }

        public int getEndIndex() {
            return this.endIndex;
        }
    }

    public class ReservedFieldException
    extends Exception {
        public ReservedFieldException(String msg) {
            super(msg);
        }
    }

    public static enum ConditionType {
        NONE,
        STRING,
        REGEX;

    }

    public static enum CursorStrategy {
        CUT,
        COPY;

    }

    public static enum Type {
        SUBSTRING,
        REGEX,
        SPLIT_AND_INDEX,
        COPY_INPUT;

    }
}

