/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin.indexer.retention;

import com.google.common.base.Stopwatch;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.graylog2.plugin.indexer.retention.IndexManagement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RetentionStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(RetentionStrategy.class);
    private final IndexManagement indexManagement;

    protected RetentionStrategy(IndexManagement indexManagement) {
        this.indexManagement = indexManagement;
    }

    protected abstract void onMessage(Map<String, String> var1);

    protected abstract boolean iterates();

    protected abstract Art getArt();

    public void runStrategy(String indexName) {
        Stopwatch sw = Stopwatch.createStarted();
        if (this.iterates()) {
            // empty if block
        }
        switch (this.getArt()) {
            case DELETE: {
                LOG.info("Strategy is deleting.");
                this.indexManagement.delete(indexName);
                break;
            }
            case CLOSE: {
                LOG.info("Strategy is closing.");
                this.indexManagement.close(indexName);
            }
        }
        LOG.info("Finished index retention strategy [" + this.getClass().getCanonicalName() + "] for " + "index <{}> in {}ms.", (Object)indexName, (Object)sw.stop().elapsed(TimeUnit.MILLISECONDS));
    }

    public static enum Art {
        DELETE,
        CLOSE;

    }
}

