/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin.configuration.fields;

import com.google.common.collect.Lists;
import java.util.List;
import org.graylog2.plugin.configuration.fields.AbstractConfigurationField;
import org.graylog2.plugin.configuration.fields.ConfigurationField;

public class NumberField
extends AbstractConfigurationField
implements ConfigurationField {
    public static final String FIELD_TYPE = "number";
    private final int defaultValue;
    private final List<String> attributes;

    public NumberField(String name, String humanName, int defaultValue, String description, ConfigurationField.Optional isOptional) {
        this(name, humanName, defaultValue, description, isOptional, null);
    }

    public NumberField(String name, String humanName, int defaultValue, String description, Attribute ... attributes) {
        this(name, humanName, defaultValue, description, ConfigurationField.Optional.NOT_OPTIONAL, attributes);
    }

    public NumberField(String name, String humanName, int defaultValue, String description, ConfigurationField.Optional isOptional, Attribute ... attrs) {
        super(FIELD_TYPE, name, humanName, description, isOptional);
        this.defaultValue = defaultValue;
        this.attributes = Lists.newArrayList();
        if (attrs != null) {
            for (Attribute attribute : attrs) {
                this.attributes.add(attribute.toString().toLowerCase());
            }
        }
    }

    @Override
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public List<String> getAttributes() {
        return this.attributes;
    }

    public static enum Attribute {
        ONLY_POSITIVE,
        ONLY_NEGATIVE,
        IS_PORT_NUMBER;

    }
}

