/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin.configuration.fields;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.graylog2.plugin.configuration.fields.AbstractConfigurationField;
import org.graylog2.plugin.configuration.fields.ConfigurationField;

public class DropdownField
extends AbstractConfigurationField
implements ConfigurationField {
    public static final String FIELD_TYPE = "dropdown";
    private final String defaultValue;
    private final Map<String, String> values;

    public DropdownField(String name, String humanName, String defaultValue, Map<String, String> values2, ConfigurationField.Optional isOptional) {
        this(name, humanName, defaultValue, values2, null, isOptional);
    }

    public DropdownField(String name, String humanName, String defaultValue, Map<String, String> values2, String description, ConfigurationField.Optional isOptional) {
        super(FIELD_TYPE, name, humanName, description, isOptional);
        this.defaultValue = defaultValue;
        this.values = values2;
    }

    @Override
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Map<String, Map<String, String>> getAdditionalInformation() {
        HashMap<String, Map<String, String>> result2 = Maps.newHashMap();
        result2.put("values", this.values);
        return result2;
    }

    public static class ValueTemplates {
        public static Map<String, String> timeUnits() {
            HashMap<String, String> units = Maps.newHashMap();
            for (TimeUnit unit : TimeUnit.values()) {
                String human = unit.toString().toLowerCase();
                units.put(unit.toString(), Character.toUpperCase(human.charAt(0)) + human.substring(1));
            }
            return units;
        }
    }
}

