/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin.configuration;

import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.graylog2.plugin.configuration.fields.ConfigurationField;
import org.graylog2.plugin.configuration.fields.NumberField;
import org.graylog2.plugin.configuration.fields.TextField;

public class ConfigurationRequest {
    private final List<ConfigurationField> fields = Lists.newArrayList();

    public void addField(ConfigurationField f2) {
        this.fields.add(f2);
    }

    public List<ConfigurationField> getFields() {
        return ImmutableList.copyOf(this.fields);
    }

    @JsonValue
    public Map<String, Map<String, Object>> asList() {
        HashMap<String, Map<String, Object>> configs = Maps.newHashMap();
        for (ConfigurationField f2 : this.fields) {
            HashMap<String, Object> config = Maps.newHashMap();
            config.put("type", f2.getFieldType());
            config.put("human_name", f2.getHumanName());
            config.put("description", f2.getDescription());
            config.put("default_value", f2.getDefaultValue());
            config.put("is_optional", f2.isOptional().equals((Object)ConfigurationField.Optional.OPTIONAL));
            config.put("attributes", f2.getAttributes());
            config.put("additional_info", f2.getAdditionalInformation());
            configs.put(f2.getName(), config);
        }
        return configs;
    }

    public static class Templates {
        public static ConfigurationField bindAddress(String name) {
            return new TextField(name, "Bind address", "0.0.0.0", "Address to listen on. For example 0.0.0.0 or 127.0.0.1.", new TextField.Attribute[0]);
        }

        public static ConfigurationField portNumber(String name, int port) {
            return new NumberField(name, "Port", port, "Port to listen on.", NumberField.Attribute.IS_PORT_NUMBER);
        }

        public static ConfigurationField recvBufferSize(String name, int size2) {
            return new NumberField(name, "Receive Buffer Size", size2, "The size in bytes of the recvBufferSize for network connections to this input.", ConfigurationField.Optional.OPTIONAL, NumberField.Attribute.ONLY_POSITIVE);
        }
    }
}

