/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin.configuration;

import com.google.common.collect.Maps;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration {
    private static final Logger LOG = LoggerFactory.getLogger(Configuration.class);
    private final Map<String, Object> source;
    private final Map<String, String> strings;
    private final Map<String, Integer> ints;
    private final Map<String, Boolean> bools;

    public Configuration(Map<String, Object> m) {
        this.source = m;
        this.strings = Maps.newHashMap();
        this.ints = Maps.newHashMap();
        this.bools = Maps.newHashMap();
        if (m != null) {
            for (Map.Entry<String, Object> e : m.entrySet()) {
                try {
                    if (e.getValue() instanceof String) {
                        this.strings.put(e.getKey(), (String)e.getValue());
                        continue;
                    }
                    if (e.getValue() instanceof Integer) {
                        this.ints.put(e.getKey(), (Integer)e.getValue());
                        continue;
                    }
                    if (e.getValue() instanceof Long) {
                        this.ints.put(e.getKey(), ((Long)e.getValue()).intValue());
                        continue;
                    }
                    if (e.getValue() instanceof Double) {
                        this.ints.put(e.getKey(), ((Double)e.getValue()).intValue());
                        continue;
                    }
                    if (e.getValue() instanceof Boolean) {
                        this.bools.put(e.getKey(), (Boolean)e.getValue());
                        continue;
                    }
                    LOG.error("Cannot handle type [{}] of plugin configuration key <{}>.", (Object)e.getValue().getClass().getCanonicalName(), (Object)e.getKey());
                }
                catch (Exception ex) {
                    LOG.warn("Could not read input configuration key <" + e.getKey() + ">. Skipping.", ex);
                }
            }
        }
    }

    public String getString(String key) {
        return this.strings.get(key);
    }

    public void setString(String key, String value2) {
        this.strings.put(key, value2);
    }

    public long getInt(String key) {
        return this.ints.get(key).intValue();
    }

    public boolean getBoolean(String key) {
        if (!this.bools.containsKey(key)) {
            return false;
        }
        return this.bools.get(key);
    }

    public Map<String, Object> getSource() {
        return this.source;
    }

    public boolean stringIsSet(String key) {
        return this.strings.get(key) != null && !this.strings.get(key).isEmpty();
    }

    public boolean intIsSet(String key) {
        return this.ints.get(key) != null;
    }
}

