/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import java.io.StringReader;
import java.net.URL;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Version {
    private static final Logger LOG;
    public final int major;
    public final int minor;
    public final int patch;
    public final String additional;
    public final String abbrevCommitSha;
    public static final Version CURRENT_CLASSPATH;

    public Version(int major, int minor, int patch2) {
        this(major, minor, patch2, null, null);
    }

    public Version(int major, int minor, int patch2, String additional) {
        this(major, minor, patch2, additional, null);
    }

    public Version(int major, int minor, int patch2, String additional, String abbrevCommitSha) {
        this.major = major;
        this.minor = minor;
        this.patch = patch2;
        this.additional = additional;
        this.abbrevCommitSha = abbrevCommitSha;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.major).append(".").append(this.minor).append(".").append(this.patch);
        if (this.additional != null && !this.additional.isEmpty()) {
            sb.append("-").append(this.additional);
        }
        if (this.abbrevCommitSha != null) {
            sb.append(" (").append(this.abbrevCommitSha).append(')');
        }
        return sb.toString();
    }

    public boolean greaterMinor(Version other) {
        if (other.major < this.major) {
            return true;
        }
        return other.major == this.major && other.minor < this.minor;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        Version version = (Version)obj;
        return this.toString().equals(version.toString());
    }

    static {
        Version tmpVersion;
        LOG = LoggerFactory.getLogger(Version.class);
        try {
            URL resource = Resources.getResource("version.properties");
            String versionProperties = Resources.toString(resource, Charsets.UTF_8);
            Properties version = new Properties();
            version.load(new StringReader(versionProperties));
            int major = Integer.parseInt(version.getProperty("version.major", "0"));
            int minor = Integer.parseInt(version.getProperty("version.minor", "0"));
            int incremental = Integer.parseInt(version.getProperty("version.incremental", "0"));
            String qualifier = version.getProperty("version.qualifier", "unknown");
            String commitSha = null;
            try {
                Properties git = new Properties();
                URL gitResource = Resources.getResource("git.properties");
                String gitProperties = Resources.toString(gitResource, Charsets.UTF_8);
                git.load(new StringReader(gitProperties));
                commitSha = git.getProperty("git.commit.id.abbrev");
            }
            catch (Exception e) {
                LOG.debug("Git commit details are not available, skipping.", e);
            }
            tmpVersion = new Version(major, minor, incremental, qualifier, commitSha);
        }
        catch (Exception e) {
            tmpVersion = new Version(0, 0, 0, "unknown");
            LOG.error("Unable to read version.properties file, this build has no version number. If you get this message during development, you need to run 'Generate Sources' in IDEA or run 'mvn process-resources'.", e);
        }
        CURRENT_CLASSPATH = tmpVersion;
    }
}

