/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin;

import com.google.common.base.Charsets;
import com.google.common.primitives.Ints;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import javax.ws.rs.core.UriBuilder;
import org.elasticsearch.search.SearchHit;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.handler.codec.base64.Base64;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.DateTimeParser;
import org.joda.time.format.ISODateTimeFormat;
import org.slf4j.Logger;

public final class Tools {
    public static final String ES_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String ES_DATE_FORMAT_NO_MS = "yyyy-MM-dd HH:mm:ss";
    public static final DateTimeFormatter ES_DATE_FORMAT_FORMATTER = DateTimeFormat.forPattern("yyyy-MM-dd HH:mm:ss.SSS").withZoneUTC();

    private Tools() {
    }

    public static String getPID() {
        return ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
    }

    public static String syslogLevelToReadable(int level) {
        switch (level) {
            case 0: {
                return "Emergency";
            }
            case 1: {
                return "Alert";
            }
            case 2: {
                return "Critical";
            }
            case 3: {
                return "Error";
            }
            case 4: {
                return "Warning";
            }
            case 5: {
                return "Notice";
            }
            case 6: {
                return "Informational";
            }
            case 7: {
                return "Debug";
            }
        }
        return "Invalid";
    }

    public static String syslogFacilityToReadable(int facility) {
        switch (facility) {
            case 0: {
                return "kernel";
            }
            case 1: {
                return "user-level";
            }
            case 2: {
                return "mail";
            }
            case 3: {
                return "system daemon";
            }
            case 4: 
            case 10: {
                return "security/authorization";
            }
            case 5: {
                return "syslogd";
            }
            case 6: {
                return "line printer";
            }
            case 7: {
                return "network news";
            }
            case 8: {
                return "UUCP";
            }
            case 9: 
            case 15: {
                return "clock";
            }
            case 11: {
                return "FTP";
            }
            case 12: {
                return "NTP";
            }
            case 13: {
                return "log audit";
            }
            case 14: {
                return "log alert";
            }
            case 16: {
                return "local0";
            }
            case 17: {
                return "local1";
            }
            case 18: {
                return "local2";
            }
            case 19: {
                return "local3";
            }
            case 20: {
                return "local4";
            }
            case 21: {
                return "local5";
            }
            case 22: {
                return "local6";
            }
            case 23: {
                return "local7";
            }
        }
        return "Unknown";
    }

    public static String getSystemInformation() {
        String ret = System.getProperty("java.vendor");
        ret = ret + " " + System.getProperty("java.version");
        ret = ret + " on " + System.getProperty("os.name");
        ret = ret + " " + System.getProperty("os.version");
        return ret;
    }

    public static String decompressZlib(byte[] compressedData) throws IOException {
        byte[] buffer = new byte[compressedData.length];
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        InflaterInputStream in = new InflaterInputStream(new ByteArrayInputStream(compressedData));
        int bytesRead = 0;
        while (bytesRead != -1) {
            out.write(buffer, 0, bytesRead);
            bytesRead = in.read(buffer);
        }
        return new String(out.toByteArray(), "UTF-8");
    }

    public static String decompressGzip(byte[] compressedData) throws IOException {
        byte[] buffer = new byte[compressedData.length];
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GZIPInputStream in = new GZIPInputStream(new ByteArrayInputStream(compressedData));
        int bytesRead = 0;
        while (bytesRead != -1) {
            out.write(buffer, 0, bytesRead);
            bytesRead = in.read(buffer);
        }
        return new String(out.toByteArray(), "UTF-8");
    }

    public static int getUTCTimestamp() {
        return (int)(System.currentTimeMillis() / 1000L);
    }

    public static double getUTCTimestampWithMilliseconds() {
        return Tools.getUTCTimestampWithMilliseconds(System.currentTimeMillis());
    }

    public static double getUTCTimestampWithMilliseconds(long timestamp) {
        return (double)timestamp / 1000.0;
    }

    public static String getLocalHostname() {
        InetAddress addr = null;
        try {
            addr = InetAddress.getLocalHost();
        }
        catch (UnknownHostException ex) {
            return "Unknown";
        }
        return addr.getHostName();
    }

    public static String getLocalCanonicalHostname() {
        InetAddress addr = null;
        try {
            addr = InetAddress.getLocalHost();
        }
        catch (UnknownHostException ex) {
            return "Unknown";
        }
        return addr.getCanonicalHostName();
    }

    public static int getTimestampDaysAgo(int ts, int days) {
        return ts - days * 86400;
    }

    public static String encodeBase64(String what) {
        return Base64.encode(ChannelBuffers.wrappedBuffer(what.getBytes())).toString(Charsets.UTF_8);
    }

    public static String decodeBase64(String what) {
        return Base64.decode(ChannelBuffers.wrappedBuffer(what.getBytes())).toString(Charsets.UTF_8);
    }

    public static String rdnsLookup(InetAddress socketAddress) throws UnknownHostException {
        return socketAddress.getCanonicalHostName();
    }

    public static String generateServerId() {
        return UUID.randomUUID().toString();
    }

    public static <T extends Comparable<? super T>> List<T> asSortedList(Collection<T> c) {
        ArrayList<T> list2 = new ArrayList<T>(c);
        Collections.sort(list2);
        return list2;
    }

    public static String buildElasticSearchTimeFormat(DateTime timestamp) {
        return timestamp.toString(DateTimeFormat.forPattern(ES_DATE_FORMAT).withZoneUTC());
    }

    public static DateTime dateTimeFromDouble(double x2) {
        return new DateTime(Math.round(x2 * 1000.0), DateTimeZone.UTC);
    }

    public static DateTimeFormatter timeFormatterWithOptionalMilliseconds() {
        DateTimeParser ms = new DateTimeFormatterBuilder().appendLiteral(".").appendFractionOfSecond(1, 3).toParser();
        return new DateTimeFormatterBuilder().append(DateTimeFormat.forPattern(ES_DATE_FORMAT_NO_MS).withZoneUTC()).appendOptional(ms).toFormatter();
    }

    public static int getTimestampOfMessage(SearchHit msg) {
        Object field2 = msg.getSource().get("timestamp");
        if (field2 == null) {
            throw new RuntimeException("Document has no field timestamp.");
        }
        DateTimeFormatter formatter = DateTimeFormat.forPattern(ES_DATE_FORMAT).withZoneUTC();
        DateTime dt = formatter.parseDateTime(field2.toString());
        return (int)(dt.getMillis() / 1000L);
    }

    public static DateTime iso8601() {
        return new DateTime(DateTimeZone.UTC);
    }

    public static String getISO8601String(DateTime time) {
        return ISODateTimeFormat.dateTime().print(time);
    }

    public static String elasticSearchTimeFormatToISO8601(String time) {
        try {
            DateTime dt = DateTime.parse(time, ES_DATE_FORMAT_FORMATTER);
            return Tools.getISO8601String(dt);
        }
        catch (IllegalArgumentException e) {
            return time;
        }
    }

    public static String safeSubstring(String target, int start, int end) {
        if (target == null) {
            return null;
        }
        int slen = target.length();
        if (start < 0 || end <= 0 || end <= start || slen < start || slen < end) {
            return null;
        }
        return target.substring(start, end);
    }

    public static Integer getInt(Object x2) {
        String s;
        if (x2 == null) {
            return null;
        }
        if (x2 instanceof Integer) {
            return (Integer)x2;
        }
        if (x2 instanceof String && ((s = x2.toString()) == null || s.isEmpty())) {
            return null;
        }
        return Ints.tryParse(x2.toString());
    }

    public static InetAddress guessPrimaryNetworkAddress() throws SocketException {
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        for (NetworkInterface interf : Collections.list(interfaces)) {
            if (interf.isLoopback() || !interf.isUp()) continue;
            for (InetAddress addr : Collections.list(interf.getInetAddresses())) {
                if (!(addr instanceof Inet4Address)) continue;
                return addr;
            }
        }
        return InetAddress.getLoopbackAddress();
    }

    public static URI getUriStandard(String from2) {
        try {
            URI uri = new URI(from2);
            if (uri.getPort() == -1) {
                return UriBuilder.fromUri(uri).port(80).build(new Object[0]);
            }
            return uri;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Could not parse REST listen URI.", e);
        }
    }

    public static <T, E> T getKeyByValue(Map<T, E> map2, E value2) {
        for (Map.Entry<T, E> entry2 : map2.entrySet()) {
            if (!value2.equals(entry2.getValue())) continue;
            return entry2.getKey();
        }
        return null;
    }

    public static void silenceUncaughtExceptionsInThisThread() {
        Thread.currentThread().setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread ignored, Throwable ignored1) {
            }
        });
    }

    public static class LogUncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private final Logger log;

        public LogUncaughtExceptionHandler(Logger log2) {
            this.log = log2;
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            this.log.error("Thread {} failed by not catching exception: {}.", (Object)t.getName(), (Object)e);
        }
    }

    public static class NoInterfaceFoundException
    extends Exception {
    }
}

