/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.graylog2.plugin.Message;
import org.joda.time.DateTime;
import org.msgpack.MessagePack;

@org.msgpack.annotation.Message
public class RadioMessage {
    public Map<String, String> strings;
    public Map<String, Long> longs;
    public Map<String, Double> doubles;
    public long timestamp;

    public static byte[] serialize(MessagePack pack, Message msg) throws IOException {
        HashMap<String, Long> longs = Maps.newHashMap();
        HashMap<String, String> strings = Maps.newHashMap();
        HashMap<String, Double> doubles = Maps.newHashMap();
        for (Map.Entry<String, Object> field2 : msg.getFields().entrySet()) {
            if (field2.getValue() instanceof String) {
                strings.put(field2.getKey(), (String)field2.getValue());
                continue;
            }
            if (field2.getValue() instanceof Long || field2.getValue() instanceof Integer) {
                longs.put(field2.getKey(), ((Number)field2.getValue()).longValue());
                continue;
            }
            if (field2.getValue() instanceof Double || field2.getValue() instanceof Float) {
                doubles.put(field2.getKey(), ((Number)field2.getValue()).doubleValue());
                continue;
            }
            if (field2.getValue() instanceof Boolean) {
                strings.put(field2.getKey(), field2.getValue().toString());
                continue;
            }
            if (!(field2.getValue() instanceof Character)) continue;
            strings.put(field2.getKey(), String.valueOf(field2.getValue()));
        }
        RadioMessage radioMessage = new RadioMessage();
        radioMessage.strings = strings;
        radioMessage.longs = longs;
        radioMessage.doubles = doubles;
        radioMessage.timestamp = ((DateTime)msg.getField("timestamp")).getMillis();
        return pack.write(radioMessage);
    }
}

