/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin;

import com.eaio.uuid.UUID;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.plugin.streams.Stream;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Message {
    private static final Logger LOG = LoggerFactory.getLogger(Message.class);
    private Map<String, Object> fields = Maps.newHashMap();
    private List<Stream> streams = Lists.newArrayList();
    private MessageInput sourceInput;
    private static final Pattern VALID_KEY_CHARS = Pattern.compile("^[\\w\\.\\-]*$");
    private boolean filterOut = false;
    public static final ImmutableSet<String> RESERVED_FIELDS = ImmutableSet.of("_id", "_ttl", "_source", "_all", "_index", "_type", new String[]{"_score", "message", "source", "timestamp", "gl2_source_node", "gl2_source_input", "gl2_source_radio", "gl2_source_radio_input"});
    public static final ImmutableSet<String> RESERVED_SETTABLE_FIELDS = ImmutableSet.of("message", "source", "timestamp", "gl2_source_node", "gl2_source_input", "gl2_source_radio", new String[]{"gl2_source_radio_input"});
    private static final ImmutableSet<String> REQUIRED_FIELDS = ImmutableSet.of("message", "source", "_id");
    public static final Function<Message, String> ID_FUNCTION = new MessageIdFunction();
    private InetAddress inetAddress;

    public Message(String message, String source, DateTime timestamp) {
        this.fields.put("_id", new UUID().toString());
        this.fields.put("message", message);
        this.fields.put("source", source);
        this.fields.put("timestamp", timestamp);
        this.streams = Lists.newArrayList();
    }

    public Message(Map<String, Object> fields) {
        this.fields.putAll(fields);
    }

    public boolean isComplete() {
        for (String key : REQUIRED_FIELDS) {
            if (this.getField(key) != null && !((String)this.getField(key)).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public String getValidationErrors() {
        StringBuilder sb = new StringBuilder();
        for (String key : REQUIRED_FIELDS) {
            if (this.getField(key) == null) {
                sb.append(key).append(" is missing, ");
                continue;
            }
            if (!((String)this.getField(key)).isEmpty()) continue;
            sb.append(key).append(" is empty, ");
        }
        return sb.toString();
    }

    public String getId() {
        return (String)this.getField("_id");
    }

    public Map<String, Object> toElasticSearchObject() {
        HashMap<String, Object> obj = Maps.newHashMap();
        obj.put("message", this.getMessage());
        obj.put("source", this.getSource());
        obj.putAll(this.getFields());
        if (this.getField("timestamp") instanceof DateTime) {
            obj.put("timestamp", Tools.buildElasticSearchTimeFormat(((DateTime)this.getField("timestamp")).withZone(DateTimeZone.UTC)));
        }
        if (this.getStreams().size() > 0) {
            ArrayList<String> streamIds = Lists.newArrayList();
            for (Stream stream : this.getStreams()) {
                streamIds.add(stream.getId());
            }
            obj.put("streams", streamIds);
        } else {
            obj.put("streams", Collections.EMPTY_LIST);
        }
        return obj;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("source: ").append(this.getField("source")).append(" | ");
        String message = this.getField("message").toString().replaceAll("\\n", "").replaceAll("\\t", "");
        sb.append("message: ");
        if (message.length() > 225) {
            message = message.substring(0, 225);
            sb.append(message).append(" (...)");
        } else {
            sb.append(message);
        }
        HashMap<String, Object> filteredFields = Maps.newHashMap(this.fields);
        filteredFields.remove("source");
        filteredFields.remove("message");
        for (Map.Entry entry2 : filteredFields.entrySet()) {
            sb.append(" | ").append((String)entry2.getKey()).append(": ").append(entry2.getValue());
        }
        return sb.toString();
    }

    public String getMessage() {
        return (String)this.getField("message");
    }

    public String getSource() {
        return (String)this.getField("source");
    }

    public void addField(String key, Object value2) {
        if (value2 == null) {
            return;
        }
        if (String.class.equals(value2.getClass()) && ((String)(value2 = ((String)value2).trim())).isEmpty()) {
            return;
        }
        if (RESERVED_FIELDS.contains(key) && !RESERVED_SETTABLE_FIELDS.contains(key)) {
            return;
        }
        if (!Message.validKey(key)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Ignoring invalid key {} for message {}", (Object)key, (Object)this.getId());
            }
            return;
        }
        this.fields.put(key.trim(), value2);
    }

    public static boolean validKey(String key) {
        return VALID_KEY_CHARS.matcher(key).matches();
    }

    public void addFields(Map<String, Object> fields) {
        if (fields == null) {
            return;
        }
        for (Map.Entry<String, Object> field2 : fields.entrySet()) {
            this.addField(field2.getKey(), field2.getValue());
        }
    }

    public void addStringFields(Map<String, String> fields) {
        if (fields == null) {
            return;
        }
        for (Map.Entry<String, String> field2 : fields.entrySet()) {
            this.addField(field2.getKey(), field2.getValue());
        }
    }

    public void addLongFields(Map<String, Long> fields) {
        if (fields == null) {
            return;
        }
        for (Map.Entry<String, Long> field2 : fields.entrySet()) {
            this.addField(field2.getKey(), field2.getValue());
        }
    }

    public void addDoubleFields(Map<String, Double> fields) {
        if (fields == null) {
            return;
        }
        for (Map.Entry<String, Double> field2 : fields.entrySet()) {
            this.addField(field2.getKey(), field2.getValue());
        }
    }

    public void removeField(String key) {
        if (!RESERVED_FIELDS.contains(key)) {
            this.fields.remove(key);
        }
    }

    public <T> T getFieldAs(Class<T> T, String key) throws ClassCastException {
        Object rawField = this.getField(key);
        return T.cast(rawField);
    }

    public Object getField(String key) {
        return this.fields.get(key);
    }

    public Map<String, Object> getFields() {
        return ImmutableMap.copyOf(this.fields);
    }

    public void setStreams(List<Stream> streams2) {
        this.streams = streams2;
    }

    public List<Stream> getStreams() {
        return this.streams;
    }

    public List<String> getStreamIds() {
        ArrayList<String> result2 = new ArrayList<String>();
        try {
            result2.addAll((Collection)this.getFieldAs(result2.getClass(), "streams"));
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return result2;
    }

    public void setFilterOut(boolean set) {
        this.filterOut = set;
    }

    public boolean getFilterOut() {
        return this.filterOut;
    }

    public MessageInput getSourceInput() {
        return this.sourceInput;
    }

    public void setSourceInput(MessageInput input2) {
        this.sourceInput = input2;
    }

    public boolean getIsSourceInetAddress() {
        return this.inetAddress != null;
    }

    public InetAddress getInetAddress() {
        return this.inetAddress;
    }

    public static class MessageIdFunction
    implements Function<Message, String> {
        @Override
        public String apply(Message input2) {
            return input2.getId();
        }
    }
}

