/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin;

import com.github.joschi.jadconfig.Parameter;
import com.github.joschi.jadconfig.validators.InetPortValidator;
import com.github.joschi.jadconfig.validators.PositiveIntegerValidator;
import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.BusySpinWaitStrategy;
import com.lmax.disruptor.SleepingWaitStrategy;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.YieldingWaitStrategy;
import java.net.InetAddress;
import java.net.URI;
import org.graylog2.plugin.Tools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(BaseConfiguration.class);
    @Parameter(value="rest_transport_uri", required=false)
    private String restTransportUri;
    @Parameter(value="processbuffer_processors", required=true, validator=PositiveIntegerValidator.class)
    private int processBufferProcessors = 5;
    @Parameter(value="processor_wait_strategy", required=true)
    private String processorWaitStrategy = "blocking";
    @Parameter(value="rest_enable_cors")
    private boolean restEnableCors = false;
    @Parameter(value="rest_enable_gzip")
    private boolean restEnableGzip = false;
    @Parameter(value="groovy_shell_enable")
    private boolean groovyShellEnable = false;
    @Parameter(value="groovy_shell_port", validator=InetPortValidator.class)
    private int groovyShellPort = 6789;
    @Parameter(value="plugin_dir")
    private String pluginDir = "plugin";
    @Parameter(value="async_eventbus_processors")
    private int asyncEventbusProcessors = 2;
    @Parameter(value="input_cache_max_size")
    private long inputCacheMaxSize = 0L;

    public URI getRestTransportUri() {
        if (this.restTransportUri == null || this.restTransportUri.isEmpty()) {
            return null;
        }
        return Tools.getUriStandard(this.restTransportUri);
    }

    public void setRestTransportUri(String restTransportUri) {
        this.restTransportUri = restTransportUri;
    }

    public URI getDefaultRestTransportUri() {
        URI transportUri;
        URI listenUri = this.getRestListenUri();
        if (listenUri.getHost().equals("0.0.0.0")) {
            InetAddress guessedAddress;
            try {
                guessedAddress = Tools.guessPrimaryNetworkAddress();
                if (guessedAddress.isLoopbackAddress()) {
                    LOG.debug("Using loopback address {}", (Object)guessedAddress);
                }
            }
            catch (Exception e) {
                LOG.error("Could not guess primary network address for rest_transport_uri. Please configure it in your graylog2.conf.", e);
                throw new RuntimeException("No rest_transport_uri.", e);
            }
            transportUri = Tools.getUriStandard("http://" + guessedAddress.getHostAddress() + ":" + listenUri.getPort());
        } else {
            transportUri = listenUri;
        }
        return transportUri;
    }

    public int getProcessBufferProcessors() {
        return this.processBufferProcessors;
    }

    public WaitStrategy getProcessorWaitStrategy() {
        if (this.processorWaitStrategy.equals("sleeping")) {
            return new SleepingWaitStrategy();
        }
        if (this.processorWaitStrategy.equals("yielding")) {
            return new YieldingWaitStrategy();
        }
        if (this.processorWaitStrategy.equals("blocking")) {
            return new BlockingWaitStrategy();
        }
        if (this.processorWaitStrategy.equals("busy_spinning")) {
            return new BusySpinWaitStrategy();
        }
        LOG.warn("Invalid setting for [processor_wait_strategy]: Falling back to default: BlockingWaitStrategy.");
        return new BlockingWaitStrategy();
    }

    public boolean isRestEnableCors() {
        return this.restEnableCors;
    }

    public boolean isRestEnableGzip() {
        return this.restEnableGzip;
    }

    public boolean isGroovyShellEnable() {
        return this.groovyShellEnable;
    }

    public int getGroovyShellPort() {
        return this.groovyShellPort;
    }

    public String getPluginDir() {
        return this.pluginDir;
    }

    public int getAsyncEventbusProcessors() {
        return this.asyncEventbusProcessors;
    }

    public long getInputCacheMaxSize() {
        return this.inputCacheMaxSize;
    }

    public abstract String getNodeIdFile();

    public abstract URI getRestListenUri();
}

