/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.periodical;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.periodical.Periodical;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Periodicals {
    private static final Logger LOG = LoggerFactory.getLogger(Periodicals.class);
    private final List<Periodical> periodicals;
    private final Map<Periodical, ScheduledFuture> futures;
    private final ScheduledExecutorService scheduler;
    private final ScheduledExecutorService daemonScheduler;

    public Periodicals(ScheduledExecutorService scheduler, ScheduledExecutorService daemonScheduler) {
        this.scheduler = scheduler;
        this.daemonScheduler = daemonScheduler;
        this.periodicals = Lists.newArrayList();
        this.futures = Maps.newHashMap();
    }

    public synchronized void registerAndStart(Periodical periodical) {
        if (periodical.runsForever()) {
            LOG.info("Starting [{}] periodical, running forever.", (Object)periodical.getClass().getCanonicalName());
            Thread t = new Thread(periodical);
            t.setDaemon(periodical.isDaemon());
            t.setName("periodical-" + periodical.getClass().getCanonicalName());
            t.setUncaughtExceptionHandler(new Tools.LogUncaughtExceptionHandler(LOG));
            t.start();
        } else {
            LOG.info("Starting [{}] periodical in [{}s], polling every [{}s].", periodical.getClass().getCanonicalName(), periodical.getInitialDelaySeconds(), periodical.getPeriodSeconds());
            ScheduledExecutorService scheduler = periodical.isDaemon() ? this.daemonScheduler : this.scheduler;
            ScheduledFuture<?> future = scheduler.scheduleAtFixedRate(periodical, periodical.getInitialDelaySeconds(), periodical.getPeriodSeconds(), TimeUnit.SECONDS);
            this.futures.put(periodical, future);
        }
        this.periodicals.add(periodical);
    }

    public List<Periodical> getAll() {
        return Lists.newArrayList(this.periodicals);
    }

    public List<Periodical> getAllStoppedOnGracefulShutdown() {
        ArrayList<Periodical> result2 = Lists.newArrayList();
        for (Periodical periodical : this.periodicals) {
            if (!periodical.stopOnGracefulShutdown()) continue;
            result2.add(periodical);
        }
        return result2;
    }

    public Map<Periodical, ScheduledFuture> getFutures() {
        return Maps.newHashMap(this.futures);
    }
}

