/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.jersey.container.netty;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import jersey.repackaged.com.google.common.collect.Maps;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkedRequestAssembler {
    private static final Logger log = LoggerFactory.getLogger(ChunkedRequestAssembler.class);
    private final ConcurrentMap<Channel, List<HttpChunk>> chunkMap = Maps.newConcurrentMap();
    private final ConcurrentMap<Channel, HttpRequest> initialRequests = Maps.newConcurrentMap();

    public void setup(Channel channel, HttpRequest httpRequest) {
        this.chunkMap.putIfAbsent(channel, new ArrayList());
        this.initialRequests.put(channel, httpRequest);
    }

    public HttpRequest assemble(Channel channel) {
        List chunkList = (List)this.chunkMap.remove(channel);
        HttpRequest request = (HttpRequest)this.initialRequests.remove(channel);
        ChannelBuffer dstBuffer = ChannelBuffers.dynamicBuffer();
        request.setContent(dstBuffer);
        try {
            for (HttpChunk chunk : chunkList) {
                dstBuffer.writeBytes(chunk.getContent());
            }
        }
        catch (Exception e) {
            log.warn("Caught exception: " + e);
        }
        return request;
    }

    public void addChunk(Channel channel, HttpChunk nextChunk) {
        ((List)this.chunkMap.get(channel)).add(nextChunk);
    }
}

