/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.syslog.udp;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.inject.Inject;
import org.graylog2.inputs.syslog.SyslogInputBase;
import org.graylog2.inputs.syslog.udp.SyslogUDPPipelineFactory;
import org.graylog2.plugin.buffers.Buffer;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.inputs.MisfireException;
import org.jboss.netty.bootstrap.ConnectionlessBootstrap;
import org.jboss.netty.channel.ChannelException;
import org.jboss.netty.channel.FixedReceiveBufferSizePredictorFactory;
import org.jboss.netty.channel.socket.nio.NioDatagramChannelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyslogUDPInput
extends SyslogInputBase {
    private static final Logger LOG = LoggerFactory.getLogger(SyslogUDPInput.class);
    public static final String NAME = "Syslog UDP";
    private final MetricRegistry metricRegistry;

    @Inject
    public SyslogUDPInput(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
    }

    @Override
    public void initialize(Configuration configuration) {
        super.initialize(configuration);
        for (Map.Entry<String, Gauge<Long>> gauge : this.throughputCounter.gauges().entrySet()) {
            this.metricRegistry.register(MetricRegistry.name(this.getUniqueReadableId(), gauge.getKey()), (Metric)gauge.getValue());
        }
    }

    @Override
    public void launch(Buffer processBuffer) throws MisfireException {
        ExecutorService workerThreadPool = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("input-" + this.getId() + "-syslogudp-worker-%d").build());
        this.bootstrap = new ConnectionlessBootstrap(new NioDatagramChannelFactory(workerThreadPool));
        this.bootstrap.setOption("receiveBufferSizePredictorFactory", new FixedReceiveBufferSizePredictorFactory(8192));
        this.bootstrap.setOption("receiveBufferSize", this.getRecvBufferSize());
        this.bootstrap.setPipelineFactory(new SyslogUDPPipelineFactory(this.metricRegistry, processBuffer, this.configuration, this, this.throughputCounter));
        try {
            this.channel = ((ConnectionlessBootstrap)this.bootstrap).bind(this.socketAddress);
            LOG.info("Started syslog UDP input server on {}", (Object)this.socketAddress);
        }
        catch (ChannelException e) {
            String msg = "Could not bind UDP syslog input to address " + this.socketAddress;
            LOG.error(msg, e);
            throw new MisfireException(msg, e);
        }
    }

    @Override
    public String getName() {
        return NAME;
    }
}

