/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.syslog.tcp;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.inject.Inject;
import org.graylog2.inputs.syslog.SyslogInputBase;
import org.graylog2.inputs.syslog.tcp.SyslogTCPPipelineFactory;
import org.graylog2.plugin.buffers.Buffer;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.configuration.ConfigurationRequest;
import org.graylog2.plugin.configuration.fields.BooleanField;
import org.graylog2.plugin.inputs.MisfireException;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.ChannelException;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyslogTCPInput
extends SyslogInputBase {
    private static final Logger LOG = LoggerFactory.getLogger(SyslogTCPInput.class);
    public static final String NAME = "Syslog TCP";
    public static final String CK_USE_NULL_DELIMITER = "use_null_delimiter";
    private final MetricRegistry metricRegistry;

    @Inject
    public SyslogTCPInput(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
    }

    @Override
    public void initialize(Configuration configuration) {
        super.initialize(configuration);
        for (Map.Entry<String, Gauge<Long>> gauge : this.throughputCounter.gauges().entrySet()) {
            this.metricRegistry.register(MetricRegistry.name(this.getUniqueReadableId(), gauge.getKey()), (Metric)gauge.getValue());
        }
        this.metricRegistry.register(MetricRegistry.name(this.getUniqueReadableId(), "open_connections"), this.connectionCounter.gaugeCurrent());
        this.metricRegistry.register(MetricRegistry.name(this.getUniqueReadableId(), "total_connections"), this.connectionCounter.gaugeTotal());
    }

    @Override
    public void launch(Buffer processBuffer) throws MisfireException {
        ExecutorService bossThreadPool = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("input-" + this.getId() + "-syslogtcp-boss-%d").build());
        ExecutorService workerThreadPool = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("input-" + this.getId() + "-syslogtcp-worker-%d").build());
        this.bootstrap = new ServerBootstrap(new NioServerSocketChannelFactory((Executor)bossThreadPool, workerThreadPool));
        this.bootstrap.setPipelineFactory(new SyslogTCPPipelineFactory(this.metricRegistry, processBuffer, this.configuration, this, this.throughputCounter, this.connectionCounter));
        this.bootstrap.setOption("child.receiveBufferSize", this.getRecvBufferSize());
        try {
            this.channel = ((ServerBootstrap)this.bootstrap).bind(this.socketAddress);
            LOG.info("Started syslog TCP input on {}", (Object)this.socketAddress);
        }
        catch (ChannelException e) {
            String msg = "Could not bind syslog TCP input to address " + this.socketAddress;
            LOG.error(msg, e);
            throw new MisfireException(msg, e);
        }
    }

    @Override
    public ConfigurationRequest getRequestedConfiguration() {
        ConfigurationRequest x2 = super.getRequestedConfiguration();
        x2.addField(new BooleanField(CK_USE_NULL_DELIMITER, "Null frame delimiter?", false, "Use null byte as frame delimiter? Default is newline."));
        return x2;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

