/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.syslog;

import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class SyslogMessage {
    private final int facility;
    private final int severity;
    private final DateTime dateTime;
    private final String hostname;

    public SyslogMessage(int facility, int severity, DateTime dateTime, String hostname) {
        this.facility = facility;
        this.severity = severity;
        this.dateTime = dateTime;
        this.hostname = hostname;
    }

    public int getFacility() {
        return this.facility;
    }

    public int getSeverity() {
        return this.severity;
    }

    public DateTime getDateTime() {
        return this.dateTime;
    }

    public String toString() {
        return "SyslogMessage{facility=" + this.facility + ", severity=" + this.severity + ", dateTime=" + this.dateTime.withZone(DateTimeZone.UTC) + ", hostname='" + this.hostname + '\'' + '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int facility;
        private int severity;
        private DateTime dateTime;
        private String hostname;

        private Builder() {
        }

        public SyslogMessage build() {
            return new SyslogMessage(this.facility, this.severity, this.dateTime, this.hostname);
        }

        public Builder facility(int facility) {
            this.facility = facility;
            return this;
        }

        public Builder severity(int severity) {
            this.severity = severity;
            return this;
        }

        public Builder timestamp(DateTime dateTime) {
            this.dateTime = dateTime;
            return this;
        }

        public Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }
    }
}

